/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.PathMappingResult;
import java.util.Objects;
import javax.annotation.Nullable;

public final class PathMapped<T> {
    private static final PathMapped<Object> EMPTY = new PathMapped<Object>(null, PathMappingResult.empty(), null);
    @Nullable
    private final PathMapping mapping;
    private final PathMappingResult mappingResult;
    @Nullable
    private final T value;

    public static <T> PathMapped<T> empty() {
        return EMPTY;
    }

    static <T> PathMapped<T> of(PathMapping mapping, PathMappingResult mappingResult, T value) {
        Objects.requireNonNull(mapping, "mapping");
        Objects.requireNonNull(mappingResult, "mappingResult");
        Objects.requireNonNull(value, "value");
        if (!mappingResult.isPresent()) {
            throw new IllegalArgumentException("mappingResult: " + mappingResult + " (must be present)");
        }
        return new PathMapped<T>(mapping, mappingResult, value);
    }

    private PathMapped(@Nullable PathMapping mapping, PathMappingResult mappingResult, @Nullable T value) {
        assert (mapping != null && value != null || mapping == null && value == null);
        this.mapping = mapping;
        this.mappingResult = mappingResult;
        this.value = value;
    }

    public boolean isPresent() {
        return this.mapping != null;
    }

    public PathMapping mapping() {
        this.ensurePresence();
        return this.mapping;
    }

    public PathMappingResult mappingResult() {
        this.ensurePresence();
        return this.mappingResult;
    }

    public T value() {
        this.ensurePresence();
        return this.value;
    }

    private void ensurePresence() {
        if (!this.isPresent()) {
            throw new IllegalStateException("mapping unavailable");
        }
    }

    public String toString() {
        if (this.isPresent()) {
            return MoreObjects.toStringHelper(this).add("mapping", this.mapping).add("mappingResult", this.mappingResult).add("value", this.value).toString();
        }
        return this.getClass().getSimpleName() + "{<empty>}";
    }
}

