/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.server.CatchAllPathMapping;
import com.linecorp.armeria.server.DefaultPathMapping;
import com.linecorp.armeria.server.ExactPathMapping;
import com.linecorp.armeria.server.GlobPathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import com.linecorp.armeria.server.PrefixPathMapping;
import com.linecorp.armeria.server.RegexPathMapping;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public interface PathMapping {
    public static PathMapping of(String pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        if (pathPattern.startsWith("exact:")) {
            return PathMapping.ofExact(pathPattern.substring(ExactPathMapping.PREFIX_LEN));
        }
        if (pathPattern.startsWith("prefix:")) {
            return PathMapping.ofPrefix(pathPattern.substring(PrefixPathMapping.PREFIX_LEN));
        }
        if (pathPattern.startsWith("glob:")) {
            return PathMapping.ofGlob(pathPattern.substring(GlobPathMapping.PREFIX_LEN));
        }
        if (pathPattern.startsWith("regex:")) {
            return PathMapping.ofRegex(pathPattern.substring(RegexPathMapping.PREFIX_LEN));
        }
        if (!pathPattern.startsWith("/")) {
            throw new IllegalArgumentException("pathPattern: " + pathPattern + " (not an absolute path or a unknown pattern type)");
        }
        if (!pathPattern.contains("{") && !pathPattern.contains(":")) {
            return PathMapping.ofExact(pathPattern);
        }
        return new DefaultPathMapping(pathPattern);
    }

    public static PathMapping ofRegex(Pattern regex) {
        return new RegexPathMapping(regex);
    }

    public static PathMapping ofRegex(String regex) {
        return PathMapping.ofRegex(Pattern.compile(Objects.requireNonNull(regex, "regex")));
    }

    public static PathMapping ofGlob(String glob) {
        Objects.requireNonNull(glob, "glob");
        if (glob.startsWith("/") && !glob.contains("*")) {
            return PathMapping.ofExact(glob);
        }
        return new GlobPathMapping(glob);
    }

    public static PathMapping ofPrefix(String pathPrefix) {
        return PathMapping.ofPrefix(pathPrefix, true);
    }

    public static PathMapping ofPrefix(String pathPrefix, boolean stripPrefix) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        if ("/".equals(pathPrefix)) {
            return PathMapping.ofCatchAll();
        }
        return new PrefixPathMapping(pathPrefix, stripPrefix);
    }

    public static PathMapping ofExact(String exactPath) {
        return new ExactPathMapping(exactPath);
    }

    public static PathMapping ofCatchAll() {
        return CatchAllPathMapping.INSTANCE;
    }

    public PathMappingResult apply(PathMappingContext var1);

    public Set<String> paramNames();

    public String loggerName();

    public String meterTag();

    public Optional<String> exactPath();

    public Optional<String> prefix();

    default public Optional<String> triePath() {
        return Optional.empty();
    }

    default public int complexity() {
        return 0;
    }
}

