/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class PathMappingResult {
    static final int LOWEST_SCORE = Integer.MIN_VALUE;
    static final int HIGHEST_SCORE = Integer.MAX_VALUE;
    private static final PathMappingResult EMPTY = new PathMappingResult(null, null, ImmutableMap.of(), Integer.MIN_VALUE);
    @Nullable
    private final String path;
    @Nullable
    private final String query;
    @Nullable
    private final Map<String, String> pathParams;
    private int score;
    @Nullable
    private MediaType negotiatedResponseMediaType;
    @Nullable
    private String decodedPath;

    public static PathMappingResult empty() {
        return EMPTY;
    }

    public static PathMappingResult of(String path) {
        return PathMappingResult.of(path, null);
    }

    public static PathMappingResult of(String path, @Nullable String query) {
        return PathMappingResult.of(path, query, ImmutableMap.of());
    }

    public static PathMappingResult of(String path, @Nullable String query, Map<String, String> rawPathParams) {
        return PathMappingResult.of(path, query, rawPathParams, Integer.MIN_VALUE);
    }

    public static PathMappingResult of(String path, @Nullable String query, Map<String, String> rawPathParams, int score) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(rawPathParams, "rawPathParams");
        return new PathMappingResult(path, query, rawPathParams, score);
    }

    PathMappingResult(@Nullable String path, @Nullable String query, Map<String, String> pathParams, int score) {
        assert (path != null || query == null && pathParams.isEmpty());
        this.path = path;
        this.query = query;
        this.pathParams = ImmutableMap.copyOf(pathParams);
        this.score = score;
    }

    public boolean isPresent() {
        return this.path != null;
    }

    public String path() {
        this.ensurePresence();
        return this.path;
    }

    public String decodedPath() {
        this.ensurePresence();
        String decodedPath = this.decodedPath;
        if (decodedPath != null) {
            return decodedPath;
        }
        this.decodedPath = ArmeriaHttpUtil.decodePath(this.path);
        return this.decodedPath;
    }

    @Nullable
    public String query() {
        this.ensurePresence();
        return this.query;
    }

    public Map<String, String> pathParams() {
        this.ensurePresence();
        return this.pathParams;
    }

    public int score() {
        this.ensurePresence();
        return this.score;
    }

    public boolean hasHighestScore() {
        return Integer.MAX_VALUE == this.score();
    }

    public boolean hasLowestScore() {
        return Integer.MIN_VALUE == this.score();
    }

    void setScore(int score) {
        this.ensurePresence();
        this.score = score;
    }

    @Nullable
    public MediaType negotiatedResponseMediaType() {
        this.ensurePresence();
        return this.negotiatedResponseMediaType;
    }

    @Deprecated
    @Nullable
    public MediaType negotiatedProduceType() {
        return this.negotiatedResponseMediaType();
    }

    void setNegotiatedResponseMediaType(MediaType negotiatedResponseMediaType) {
        this.ensurePresence();
        this.negotiatedResponseMediaType = negotiatedResponseMediaType;
    }

    private void ensurePresence() {
        if (!this.isPresent()) {
            throw new IllegalStateException("mapping unavailable");
        }
    }

    public String toString() {
        if (this.isPresent()) {
            String score = String.valueOf(this.score);
            if (this.hasHighestScore()) {
                score = score + " (highest)";
            } else if (this.hasLowestScore()) {
                score = score + " (lowest)";
            }
            return MoreObjects.toStringHelper(this).add("path", this.path).add("query", this.query).add("pathParams", this.pathParams).add("score", score).add("negotiatedResponseMediaType", this.negotiatedResponseMediaType).toString();
        }
        return this.getClass().getSimpleName() + "{<empty>}";
    }
}

