/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.PathMappingResult;
import java.util.Objects;
import javax.annotation.Nullable;

public final class PathMappingResultBuilder {
    private final String path;
    @Nullable
    private final String query;
    private final ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
    private int score = Integer.MIN_VALUE;

    public PathMappingResultBuilder(String path) {
        this(path, null);
    }

    public PathMappingResultBuilder(String path, @Nullable String query) {
        this.path = Objects.requireNonNull(path, "path");
        this.query = query;
    }

    public PathMappingResultBuilder score(int score) {
        this.score = score;
        return this;
    }

    public PathMappingResultBuilder decodedParam(String name, String value) {
        this.params.put(Objects.requireNonNull(name, "name"), Objects.requireNonNull(value, "value"));
        return this;
    }

    public PathMappingResultBuilder rawParam(String name, String value) {
        this.params.put(Objects.requireNonNull(name, "name"), ArmeriaHttpUtil.decodePath(Objects.requireNonNull(value, "value")));
        return this;
    }

    public PathMappingResult build() {
        return new PathMappingResult(this.path, this.query, this.params.build(), this.score);
    }
}

