/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import java.util.Optional;
import java.util.Set;

final class PrefixPathMapping
extends AbstractPathMapping {
    static final String PREFIX = "prefix:";
    static final int PREFIX_LEN = "prefix:".length();
    private final String prefix;
    private final boolean stripPrefix;
    private final String loggerName;
    private final String meterTag;
    private final Optional<String> triePath;
    private final String strVal;

    PrefixPathMapping(String prefix, boolean stripPrefix) {
        prefix = PrefixPathMapping.ensureAbsolutePath(prefix, "prefix");
        if (!prefix.endsWith("/")) {
            prefix = prefix + '/';
        }
        this.prefix = prefix;
        this.stripPrefix = stripPrefix;
        this.loggerName = PrefixPathMapping.loggerName(prefix);
        this.meterTag = PREFIX + prefix;
        this.triePath = Optional.of(prefix + '*');
        this.strVal = PREFIX + prefix + " (stripPrefix: " + stripPrefix + ')';
    }

    @Override
    protected PathMappingResult doApply(PathMappingContext mappingCtx) {
        String path = mappingCtx.path();
        if (!path.startsWith(this.prefix)) {
            return PathMappingResult.empty();
        }
        return PathMappingResult.of(this.stripPrefix ? path.substring(this.prefix.length() - 1) : path, mappingCtx.query());
    }

    @Override
    public Set<String> paramNames() {
        return ImmutableSet.of();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    public String meterTag() {
        return this.meterTag;
    }

    @Override
    public Optional<String> triePath() {
        return this.triePath;
    }

    public int hashCode() {
        return this.stripPrefix ? this.prefix.hashCode() : -this.prefix.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PrefixPathMapping)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PrefixPathMapping that = (PrefixPathMapping)obj;
        return this.stripPrefix == that.stripPrefix && this.prefix.equals(that.prefix);
    }

    @Override
    public Optional<String> prefix() {
        return Optional.of(this.prefix);
    }

    public String toString() {
        return this.strVal;
    }
}

