/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RedirectService
extends AbstractHttpService {
    private static final Pattern VALID_DEFAULT_URI_PATTERN = Pattern.compile("(?:(?:^https?:/{2}(?:([^:]+:)?[^:@]+@)?[^:]+)(?::[0-9]{1,5})?)?(?:/[^/{}:]+|/:[^/{}]+|/\\{[^/{}]+})+/?");
    private static final Pattern PATTERN_PARAMS_START = Pattern.compile("/:|/\\{");
    private final HttpStatus httpStatus;
    private final Function<? super ServiceRequestContext, String> locationFunction;
    @Nullable
    private Set<String> paramNames;

    public RedirectService(String locationPattern) {
        this(HttpStatus.TEMPORARY_REDIRECT, locationPattern);
    }

    public RedirectService(Function<? super ServiceRequestContext, String> locationFunction) {
        this(HttpStatus.TEMPORARY_REDIRECT, locationFunction);
    }

    public RedirectService(HttpStatus redirectStatus, String locationPattern) {
        this(redirectStatus, RedirectService.toLocationFunction(locationPattern));
        Matcher m = PATTERN_PARAMS_START.matcher(locationPattern);
        if (m.find()) {
            this.paramNames = PathMapping.of(locationPattern.substring(m.start())).paramNames();
        }
    }

    public RedirectService(HttpStatus redirectStatus, Function<? super ServiceRequestContext, String> locationFunction) {
        Objects.requireNonNull(redirectStatus, "redirectStatus");
        Objects.requireNonNull(locationFunction, "locationFunction");
        if (redirectStatus.compareTo(HttpStatus.MULTIPLE_CHOICES) < 0 || redirectStatus.compareTo(HttpStatus.TEMPORARY_REDIRECT) > 0) {
            throw new IllegalArgumentException("redirectStatus: " + redirectStatus + " (expected: 300 .. 307)");
        }
        this.httpStatus = redirectStatus;
        this.locationFunction = locationFunction;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of((HttpHeaders)HttpHeaders.of(this.httpStatus).set(HttpHeaderNames.LOCATION, this.locationFunction.apply(ctx)));
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        if (this.paramNames != null) {
            Set<String> params = cfg.pathMapping().paramNames();
            for (String param : this.paramNames) {
                if (params.contains(param)) continue;
                throw new IllegalArgumentException("pathParams: " + param + " (no matching param in " + params + ')');
            }
            this.paramNames = null;
        }
        super.serviceAdded(cfg);
    }

    private static Function<? super ServiceRequestContext, String> toLocationFunction(String locationPattern) {
        Objects.requireNonNull(locationPattern, "locationPattern");
        if (!RedirectService.isDefaultUriPattern(locationPattern)) {
            throw new IllegalArgumentException("locationPattern: " + locationPattern);
        }
        return ctx -> RedirectService.populatePatternParams(locationPattern, ctx.pathParams());
    }

    private static String populatePatternParams(String pathPattern, Map<String, String> pathParams) {
        for (Map.Entry<String, String> e : pathParams.entrySet()) {
            String tokenPattern = "\\{" + e.getKey() + "\\}|:" + e.getKey();
            pathPattern = pathPattern.replaceAll(tokenPattern, e.getValue());
        }
        return pathPattern;
    }

    private static boolean isDefaultUriPattern(String pathPattern) {
        return VALID_DEFAULT_URI_PATTERN.matcher(pathPattern).matches();
    }
}

