/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import com.linecorp.armeria.server.PathMappingResultBuilder;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RegexPathMapping
extends AbstractPathMapping {
    static final String PREFIX = "regex:";
    static final int PREFIX_LEN = "regex:".length();
    private static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<([^>]+)>");
    private final Pattern regex;
    private final Set<String> paramNames;
    private final String loggerName;
    private final String meterTag;

    RegexPathMapping(Pattern regex) {
        this.regex = Objects.requireNonNull(regex, "regex");
        this.paramNames = RegexPathMapping.findParamNames(regex);
        this.loggerName = RegexPathMapping.toLoggerName(regex);
        this.meterTag = PREFIX + regex.pattern();
    }

    private static Set<String> findParamNames(Pattern regex) {
        Matcher matcher = NAMED_GROUP_PATTERN.matcher(regex.pattern());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int pos = 0;
        while (matcher.find(pos)) {
            builder.add(matcher.group(1));
            pos = matcher.end();
        }
        return builder.build();
    }

    @Override
    protected PathMappingResult doApply(PathMappingContext mappingCtx) {
        Matcher matcher = this.regex.matcher(mappingCtx.path());
        if (!matcher.find()) {
            return PathMappingResult.empty();
        }
        PathMappingResultBuilder builder = null;
        for (String name : this.paramNames) {
            String value = matcher.group(name);
            if (value == null) continue;
            if (builder == null) {
                builder = new PathMappingResultBuilder(mappingCtx.path(), mappingCtx.query());
            }
            builder.rawParam(name, value);
        }
        return builder != null ? builder.build() : PathMappingResult.of(mappingCtx.path(), mappingCtx.query());
    }

    @Override
    public Set<String> paramNames() {
        return this.paramNames;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private static String toLoggerName(Pattern regex) {
        String regexStr = regex.pattern();
        String prefix = "regex.";
        StringBuilder buf = new StringBuilder("regex.".length() + regexStr.length());
        buf.append("regex.");
        for (int i = 0; i < regexStr.length(); ++i) {
            char ch = regexStr.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                buf.append(ch);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    @Override
    public String meterTag() {
        return this.meterTag;
    }

    Pattern asRegex() {
        return this.regex;
    }

    public int hashCode() {
        return this.meterTag.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RegexPathMapping && (this == obj || this.regex.pattern().equals(((RegexPathMapping)obj).regex.pattern()));
    }

    public String toString() {
        return this.meterTag;
    }
}

