/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.VirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface RejectedPathMappingHandler {
    public static final RejectedPathMappingHandler WARN = (virtualHost, mapping, existingMapping) -> {
        Logger logger = LoggerFactory.getLogger(RejectedPathMappingHandler.class);
        String a = mapping.toString();
        String b = existingMapping.toString();
        String hostnamePattern = virtualHost.hostnamePattern();
        if (a.equals(b)) {
            logger.warn("Virtual host '{}' has a duplicate path mapping: {}", (Object)hostnamePattern, (Object)a);
        } else {
            logger.warn("Virtual host '{}' has path mappings with a conflict: {} vs. {}", new Object[]{hostnamePattern, a, b});
        }
    };
    public static final RejectedPathMappingHandler FAIL = (virtualHost, mapping, existingMapping) -> {
        String a = mapping.toString();
        String b = existingMapping.toString();
        String hostnamePattern = virtualHost.hostnamePattern();
        if (a.equals(b)) {
            throw new IllegalStateException("Virtual host '" + hostnamePattern + "' has a duplicate path mapping: " + a);
        }
        throw new IllegalStateException("Virtual host '" + hostnamePattern + "' has path mappings with a conflict: " + a + " vs. " + b);
    };

    public void handleDuplicatePathMapping(VirtualHost var1, PathMapping var2, PathMapping var3) throws Exception;
}

