/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.RequestContext;
import org.slf4j.Logger;
import org.slf4j.Marker;

final class RequestContextAwareLogger
implements Logger {
    private final RequestContext ctx;
    private final Logger logger;

    RequestContextAwareLogger(RequestContext ctx, Logger logger) {
        this.ctx = ctx;
        this.logger = logger;
    }

    private String decorate(String msg) {
        String prefix = this.ctx.toString();
        return new StringBuilder(prefix.length() + 1 + msg.length()).append(prefix).append(' ').append(msg).toString();
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(this.decorate(msg));
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(this.decorate(format), arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.logger.trace(this.decorate(format), arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.logger.trace(this.decorate(format), arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.logger.trace(this.decorate(msg), t);
        }
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, this.decorate(msg));
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, this.decorate(format), arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, this.decorate(format), arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, this.decorate(format), argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, this.decorate(msg), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.decorate(msg));
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.decorate(format), arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.decorate(format), arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.decorate(format), arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.decorate(msg), t);
        }
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, this.decorate(msg));
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, this.decorate(format), arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, this.decorate(format), arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, this.decorate(format), arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, this.decorate(msg), t);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.decorate(msg));
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.decorate(format), arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.decorate(format), arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.decorate(format), arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.decorate(msg), t);
        }
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, this.decorate(msg));
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(this.decorate(format), (Object)format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, this.decorate(format), arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, this.decorate(format), arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, this.decorate(msg), t);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn(this.decorate(msg));
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.logger.warn(this.decorate(format), arg);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.logger.warn(this.decorate(format), arguments);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.logger.warn(this.decorate(format), arg1, arg2);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logger.warn(this.decorate(msg), t);
        }
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, this.decorate(msg));
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, this.decorate(format), arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, this.decorate(format), arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, this.decorate(format), arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, this.decorate(msg), t);
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error(this.decorate(msg));
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.logger.error(this.decorate(format), arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.logger.error(this.decorate(format), arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.logger.error(this.decorate(format), arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logger.error(this.decorate(msg), t);
        }
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, this.decorate(msg));
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, this.decorate(format), arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, this.decorate(format), arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, this.decorate(format), arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, this.decorate(msg), t);
        }
    }

    public String toString() {
        return "ServiceAwareLogger(" + this.logger + ')';
    }
}

