/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.metric.CaffeineMetricSupport;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.PathMapped;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import com.linecorp.armeria.server.Router;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.composition.CompositeServiceEntry;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class RouteCache {
    @Nullable
    private static final Cache<PathMappingContext, ServiceConfig> CACHE = Flags.routeCacheSpec().map(RouteCache::buildCache).orElse(null);

    static Router<ServiceConfig> wrapVirtualHostRouter(Router<ServiceConfig> delegate) {
        return CACHE == null ? delegate : new CachingRouter<ServiceConfig>(delegate, CACHE, ServiceConfig::pathMapping);
    }

    static <I extends Request, O extends Response> Router<CompositeServiceEntry<I, O>> wrapCompositeServiceRouter(Router<CompositeServiceEntry<I, O>> delegate) {
        Cache cache = Flags.compositeServiceCacheSpec().map(RouteCache::buildCache).orElse(null);
        if (cache == null) {
            return delegate;
        }
        return new CachingRouter<CompositeServiceEntry<I, O>>(delegate, cache, CompositeServiceEntry::pathMapping);
    }

    private static <T> Cache<PathMappingContext, T> buildCache(String spec) {
        return Caffeine.from(spec).recordStats().build();
    }

    private RouteCache() {
    }

    private static final class CachingRouter<V>
    implements Router<V> {
        private final Router<V> delegate;
        private final Cache<PathMappingContext, V> cache;
        private final Function<V, PathMapping> pathMappingResolver;

        CachingRouter(Router<V> delegate, Cache<PathMappingContext, V> cache, Function<V, PathMapping> pathMappingResolver) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.cache = Objects.requireNonNull(cache, "cache");
            this.pathMappingResolver = Objects.requireNonNull(pathMappingResolver, "pathMappingResolver");
        }

        @Override
        public PathMapped<V> find(PathMappingContext mappingCtx) {
            V cached = this.cache.getIfPresent(mappingCtx);
            if (cached != null) {
                PathMapping mapping = this.pathMappingResolver.apply(cached);
                PathMappingResult mappingResult = mapping.apply(mappingCtx);
                return PathMapped.of(mapping, mappingResult, cached);
            }
            PathMapped<V> result = this.delegate.find(mappingCtx);
            if (result.isPresent()) {
                this.cache.put(mappingCtx, result.value());
            }
            return result;
        }

        @Override
        public boolean registerMetrics(MeterRegistry registry, MeterIdPrefix idPrefix) {
            CaffeineMetricSupport.setup(registry, idPrefix, this.cache);
            return true;
        }

        @Override
        public void dump(OutputStream output) {
            this.delegate.dump(output);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("delegate", this.delegate).add("cache", this.cache).toString();
        }
    }
}

