/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.CompositeRouter;
import com.linecorp.armeria.server.HttpHeaderPathMapping;
import com.linecorp.armeria.server.PathMapped;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import com.linecorp.armeria.server.RejectedPathMappingHandler;
import com.linecorp.armeria.server.RouteCache;
import com.linecorp.armeria.server.Router;
import com.linecorp.armeria.server.RoutingTrie;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.composition.CompositeServiceEntry;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Routers {
    private static final Logger logger = LoggerFactory.getLogger(Routers.class);

    public static Router<ServiceConfig> ofVirtualHost(VirtualHost virtualHost, Iterable<ServiceConfig> configs, RejectedPathMappingHandler rejectionHandler) {
        Objects.requireNonNull(virtualHost, "virtualHost");
        Objects.requireNonNull(configs, "configs");
        Objects.requireNonNull(rejectionHandler, "rejectionHandler");
        BiConsumer<PathMapping, PathMapping> rejectionConsumer = (mapping, existingMapping) -> {
            try {
                rejectionHandler.handleDuplicatePathMapping(virtualHost, (PathMapping)mapping, (PathMapping)existingMapping);
            }
            catch (Exception e) {
                logger.warn("Unexpected exception from a {}:", (Object)RejectedPathMappingHandler.class.getSimpleName(), (Object)e);
            }
        };
        return RouteCache.wrapVirtualHostRouter(Routers.defaultRouter(configs, ServiceConfig::pathMapping, rejectionConsumer));
    }

    public static <I extends Request, O extends Response> Router<Service<I, O>> ofCompositeService(List<CompositeServiceEntry<I, O>> entries) {
        Objects.requireNonNull(entries, "entries");
        Router delegate = RouteCache.wrapCompositeServiceRouter(Routers.defaultRouter(entries, CompositeServiceEntry::pathMapping, (mapping, existingMapping) -> {
            String b;
            String a = mapping.toString();
            if (a.equals(b = existingMapping.toString())) {
                throw new IllegalStateException("Your composite service has a duplicate path mapping: " + a);
            }
            throw new IllegalStateException("Your composite service has path mappings with a conflict: " + a + " vs. " + b);
        }));
        return new CompositeRouter(delegate, result -> result.isPresent() ? PathMapped.of(result.mapping(), result.mappingResult(), ((CompositeServiceEntry)result.value()).service()) : PathMapped.empty());
    }

    private static <V> Router<V> defaultRouter(Iterable<V> values, Function<V, PathMapping> pathMappingResolver, BiConsumer<PathMapping, PathMapping> rejectionHandler) {
        return new CompositeRouter(Routers.routers(values, pathMappingResolver, rejectionHandler), Function.identity());
    }

    static <V> List<Router<V>> routers(Iterable<V> values, Function<V, PathMapping> pathMappingResolver, BiConsumer<PathMapping, PathMapping> rejectionHandler) {
        Routers.rejectDuplicateMapping(values, pathMappingResolver, rejectionHandler);
        ImmutableList.Builder builder = ImmutableList.builder();
        ArrayList<V> group = new ArrayList<V>();
        boolean addingTrie = true;
        for (V value : values) {
            PathMapping mapping = pathMappingResolver.apply(value);
            boolean triePathPresent = mapping.triePath().isPresent();
            if (addingTrie && triePathPresent || !addingTrie && !triePathPresent) {
                group.add(value);
                continue;
            }
            if (!group.isEmpty()) {
                builder.add(Routers.router(addingTrie, group, pathMappingResolver));
            }
            addingTrie = !addingTrie;
            group.add(value);
        }
        if (!group.isEmpty()) {
            builder.add(Routers.router(addingTrie, group, pathMappingResolver));
        }
        return builder.build();
    }

    private static <V> void rejectDuplicateMapping(Iterable<V> values, Function<V, PathMapping> pathMappingResolver, BiConsumer<PathMapping, PathMapping> rejectionHandler) {
        HashMap<String, List> triePath2mappings = new HashMap<String, List>();
        for (V v : values) {
            PathMapping mapping = pathMappingResolver.apply(v);
            Optional<String> triePathOpt = mapping.triePath();
            if (!triePathOpt.isPresent()) continue;
            String triePath = triePathOpt.get();
            List existingMappings = triePath2mappings.computeIfAbsent(triePath, unused -> new ArrayList());
            for (PathMapping existingMapping : existingMappings) {
                if (mapping.complexity() != existingMapping.complexity() || mapping.getClass() != existingMapping.getClass()) continue;
                if (!(mapping instanceof HttpHeaderPathMapping)) {
                    assert (mapping.complexity() == 0);
                    assert (existingMapping.complexity() == 0);
                    rejectionHandler.accept(mapping, existingMapping);
                    return;
                }
                HttpHeaderPathMapping headerMapping = (HttpHeaderPathMapping)mapping;
                HttpHeaderPathMapping existingHeaderMapping = (HttpHeaderPathMapping)existingMapping;
                if (headerMapping.supportedMethods().stream().noneMatch(method -> existingHeaderMapping.supportedMethods().contains(method)) || !headerMapping.consumeTypes().isEmpty() && headerMapping.consumeTypes().stream().noneMatch(mediaType -> existingHeaderMapping.consumeTypes().contains(mediaType)) || !headerMapping.produceTypes().isEmpty() && headerMapping.produceTypes().stream().noneMatch(mediaType -> existingHeaderMapping.produceTypes().contains(mediaType))) continue;
                rejectionHandler.accept(mapping, existingMapping);
                return;
            }
            existingMappings.add(mapping);
        }
    }

    private static <V> Router<V> router(boolean isTrie, List<V> values, Function<V, PathMapping> pathMappingResolver) {
        Router<V> router;
        Comparator<Object> valueComparator = Comparator.comparingInt(e -> -1 * ((PathMapping)pathMappingResolver.apply(e)).complexity());
        if (isTrie) {
            RoutingTrie.Builder<Object> builder = new RoutingTrie.Builder<Object>();
            builder.comparator(valueComparator);
            values.forEach(v -> builder.add(((PathMapping)pathMappingResolver.apply(v)).triePath().get(), v));
            router = new TrieRouter(builder.build(), pathMappingResolver);
        } else {
            values.sort(valueComparator);
            router = new SequentialRouter<V>(values, pathMappingResolver);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Router created for {} service(s): {}", (Object)values.size(), (Object)router.getClass().getSimpleName());
            values.forEach(c -> {
                PathMapping mapping = (PathMapping)pathMappingResolver.apply(c);
                logger.debug("meterTag: {}, complexity: {}", (Object)mapping.meterTag(), (Object)mapping.complexity());
            });
        }
        values.clear();
        return router;
    }

    private static <V> PathMapped<V> findsBest(PathMappingContext mappingCtx, @Nullable List<V> values, Function<V, PathMapping> pathMappingResolver) {
        PathMapped<Object> result = PathMapped.empty();
        if (values != null) {
            for (V value : values) {
                PathMapping mapping = pathMappingResolver.apply(value);
                PathMappingResult mappingResult = mapping.apply(mappingCtx);
                if (!mappingResult.isPresent()) continue;
                if (mappingResult.hasHighestScore()) {
                    result = PathMapped.of(mapping, mappingResult, value);
                    break;
                }
                if (mappingResult.hasLowestScore()) {
                    if (result.isPresent()) break;
                    result = PathMapped.of(mapping, mappingResult, value);
                    break;
                }
                if (result.isPresent()) {
                    if (mappingResult.score() <= result.mappingResult().score()) continue;
                    result = PathMapped.of(mapping, mappingResult, value);
                    continue;
                }
                result = PathMapped.of(mapping, mappingResult, value);
            }
        }
        return result;
    }

    private Routers() {
    }

    private static final class SequentialRouter<V>
    implements Router<V> {
        private final List<V> values;
        private final Function<V, PathMapping> pathMappingResolver;

        SequentialRouter(List<V> values, Function<V, PathMapping> pathMappingResolver) {
            this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values"));
            this.pathMappingResolver = Objects.requireNonNull(pathMappingResolver, "pathMappingResolver");
        }

        @Override
        public PathMapped<V> find(PathMappingContext mappingCtx) {
            return Routers.findsBest(mappingCtx, this.values, this.pathMappingResolver);
        }

        @Override
        public void dump(OutputStream output) {
            PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
            p.printf("Dump of %s:%n", this);
            for (int i = 0; i < this.values.size(); ++i) {
                p.printf("<%d> %s%n", i, this.values.get(i));
            }
            p.flush();
        }
    }

    private static final class TrieRouter<V>
    implements Router<V> {
        private final RoutingTrie<V> trie;
        private final Function<V, PathMapping> pathMappingResolver;

        TrieRouter(RoutingTrie<V> trie, Function<V, PathMapping> pathMappingResolver) {
            this.trie = Objects.requireNonNull(trie, "trie");
            this.pathMappingResolver = Objects.requireNonNull(pathMappingResolver, "pathMappingResolver");
        }

        @Override
        public PathMapped<V> find(PathMappingContext mappingCtx) {
            return Routers.findsBest(mappingCtx, this.trie.find(mappingCtx.path()), this.pathMappingResolver);
        }

        @Override
        public void dump(OutputStream output) {
            this.trie.dump(output);
        }
    }
}

