/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class RoutingTrie<V> {
    private final Node<V> root;

    private RoutingTrie(Node<V> root) {
        Objects.requireNonNull(root, "root");
        this.root = root;
    }

    @Nullable
    List<V> find(String path) {
        Node<V> node = this.findNode(path, false);
        return node == null ? ImmutableList.of() : node.values();
    }

    @Nullable
    Node<V> findNode(String path) {
        return this.findNode(path, false);
    }

    @Nullable
    Node<V> findNode(String path, boolean exact) {
        Objects.requireNonNull(path, "path");
        return this.findNode(this.root, path, 0, exact);
    }

    @Nullable
    private Node<V> findNode(Node<V> node, String path, int begin, boolean exact) {
        Node<V> found;
        int next;
        switch (node.type()) {
            case EXACT: {
                int len = node.path().length();
                if (!path.regionMatches(begin, node.path(), 0, len)) {
                    return null;
                }
                if (len == path.length() - begin) {
                    return exact || node.hasValues() || !node.hasCatchAllChild() ? node : node.catchAllChild();
                }
                next = begin + len;
                break;
            }
            case PARAMETER: {
                int delim = path.indexOf(47, begin);
                if (delim < 0 || path.length() == delim + 1) {
                    return node;
                }
                next = delim;
                break;
            }
            default: {
                throw new Error("Should not reach here");
            }
        }
        Node<V> child = ((Node)node).child(path.charAt(next));
        if (child != null && (found = this.findNode(child, path, next, exact)) != null) {
            return found;
        }
        child = node.parameterChild();
        if (child != null && (found = this.findNode(child, path, next, exact)) != null) {
            return found;
        }
        child = node.catchAllChild();
        if (child != null) {
            return child;
        }
        return null;
    }

    public void dump(OutputStream output) {
        PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        p.printf("Dump of %s:%n", this);
        this.dump(p, this.root, 0);
        p.flush();
    }

    private void dump(PrintWriter p, Node<V> node, int depth) {
        p.printf("<%d> %s%n", depth, node);
        node.children().forEach(child -> this.dump(p, (Node<V>)child, depth + 1));
    }

    static final class Node<V> {
        private static final char KEY_PARAMETER = '\u0001';
        private static final char KEY_CATCH_ALL = '\u0002';
        @Nullable
        private Node<V> parent;
        private final Type type;
        private String path;
        @Nullable
        private Map<Character, Node<V>> children;
        @Nullable
        private Node<V> parameterChild;
        @Nullable
        private Node<V> catchAllChild;
        @Nullable
        private List<V> values;

        Node(@Nullable Node<V> parent, Type type, String path) {
            this.parent = parent;
            this.type = Objects.requireNonNull(type, "type");
            this.path = Objects.requireNonNull(path, "path");
        }

        String path() {
            return this.path;
        }

        private void path(String path) {
            Preconditions.checkArgument(this.path().charAt(0) == path.charAt(0), "Not acceptable path for update: " + path);
            this.path = path;
        }

        Type type() {
            return this.type;
        }

        List<V> values() {
            return this.values == null ? ImmutableList.of() : this.values;
        }

        boolean hasValues() {
            return this.values != null;
        }

        Collection<Node<V>> children() {
            return this.children == null ? ImmutableList.of() : Collections.unmodifiableCollection(this.children.values());
        }

        @Nullable
        Node<V> parameterChild() {
            return this.parameterChild;
        }

        @Nullable
        Node<V> catchAllChild() {
            return this.catchAllChild;
        }

        boolean hasCatchAllChild() {
            return this.catchAllChild != null;
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).add("path", this.path()).add("type", (Object)this.type()).add("parent", this.parent() == null ? "(null)" : this.parent().path() + '#' + (Object)((Object)this.parent().type()));
            this.children().forEach(child -> toStringHelper.add("child", child.path() + '#' + (Object)((Object)child.type())));
            toStringHelper.add("values", this.values());
            return toStringHelper.toString();
        }

        @Nullable
        Node<V> parent() {
            return this.parent;
        }

        @Nullable
        private Node<V> child(char key) {
            return this.children == null ? null : this.children.get(Character.valueOf(key));
        }

        private void addValue(V value, @Nullable Comparator<V> comparator) {
            if (this.values == null) {
                this.values = new ArrayList<V>();
            }
            this.values.add(value);
            if (comparator != null && this.values.size() > 1) {
                this.values.sort(comparator);
            }
        }

        private Node<V> addChild(Node<V> child) {
            Objects.requireNonNull(child, "child");
            char key = Node.convertKey(child.path().charAt(0));
            if (this.children == null) {
                this.children = new HashMap<Character, Node<V>>();
            }
            if (this.children.containsKey(Character.valueOf(key))) {
                throw new IllegalStateException("Path starting with '" + key + "' already exist:" + child);
            }
            this.children.put(Character.valueOf(key), child);
            switch (child.type()) {
                case PARAMETER: {
                    this.parameterChild = child;
                    break;
                }
                case CATCH_ALL: {
                    this.catchAllChild = child;
                }
            }
            return child;
        }

        private void split(int pathSplitPos) {
            Preconditions.checkArgument(pathSplitPos > 0 && pathSplitPos < this.path().length(), "Invalid split index of the path: %s", pathSplitPos);
            String parentPath = this.path().substring(0, pathSplitPos);
            String childPath = this.path().substring(pathSplitPos);
            Node child = new Node(this, this.type(), childPath);
            child.values = this.values;
            child.children = this.children;
            child.parameterChild = this.parameterChild;
            child.catchAllChild = this.catchAllChild;
            child.children().forEach(c -> {
                c.parent = child;
            });
            this.children = null;
            this.parameterChild = null;
            this.catchAllChild = null;
            this.values = null;
            this.path(parentPath);
            this.addChild(child);
        }

        static char convertKey(char key) {
            switch (key) {
                case ':': {
                    return '\u0001';
                }
                case '*': {
                    return '\u0002';
                }
            }
            return key;
        }

        static void validatePath(@Nullable String path) {
            Preconditions.checkArgument(path != null && !path.isEmpty(), "A path should not be null and empty.");
            Preconditions.checkArgument(path.indexOf(1) < 0, "A path should not contain %s: %s", (Object)Integer.toHexString(1), (Object)path);
            Preconditions.checkArgument(path.indexOf(2) < 0, "A path should not contain %s: %s", (Object)Integer.toHexString(2), (Object)path);
        }
    }

    static enum Type {
        EXACT,
        PARAMETER,
        CATCH_ALL;

    }

    static final class Builder<V> {
        private final List<Map.Entry<String, V>> routes = new ArrayList<Map.Entry<String, V>>();
        @Nullable
        private Comparator<V> comparator;

        Builder() {
        }

        Builder<V> add(String path, V value) {
            Objects.requireNonNull(path, "path");
            this.routes.add(Maps.immutableEntry(path, value));
            return this;
        }

        Builder<V> comparator(Comparator<V> comparator) {
            this.comparator = comparator;
            return this;
        }

        RoutingTrie<V> build() {
            Preconditions.checkArgument(!this.routes.isEmpty(), "No routes added");
            Preconditions.checkArgument(this.routes.stream().noneMatch(e -> ((String)e.getKey()).startsWith("*") || ((String)e.getKey()).startsWith(":")), "A path starting with '*' or ':' is not allowed.");
            this.routes.forEach(e -> Node.validatePath((String)e.getKey()));
            Node<V> root = this.insertAndGetRoot(this.routes.get(0).getKey(), this.routes.get(0).getValue());
            for (int i = 1; i < this.routes.size(); ++i) {
                Map.Entry<String, V> route = this.routes.get(i);
                this.addRoute(root, route.getKey(), route.getValue());
            }
            return new RoutingTrie(root);
        }

        private void addRoute(Node<V> node, String path, V value) {
            Node current = node;
            while (true) {
                int same;
                String p = current.path();
                int max = Math.min(p.length(), path.length());
                for (same = 0; same < max && p.charAt(same) == path.charAt(same); ++same) {
                }
                if (same < p.length()) {
                    current.split(same);
                }
                if (same == path.length()) {
                    current.addValue(value, this.comparator);
                    return;
                }
                char nextChar = Node.convertKey(path.charAt(same));
                Node next = current.child(nextChar);
                if (next == null) {
                    this.insertChild(current, path.substring(same), value);
                    return;
                }
                current = next;
                path = path.substring(same);
            }
        }

        private Node<V> insertAndGetRoot(String path, V value) {
            Node<V> node = this.insertChild(null, path, value);
            Node<V> parent;
            while ((parent = node.parent()) != null) {
                node = parent;
            }
            return node;
        }

        private Node<V> insertChild(@Nullable Node<V> node, String path, V value) {
            int pathStart = 0;
            int max = path.length();
            for (int i = 0; i < max; ++i) {
                char c = path.charAt(i);
                if (c != '*' && c != ':') continue;
                if (c == '*' && i + 1 < max) {
                    throw new IllegalStateException("Catch-all should be the last in the path: " + path);
                }
                if (i > pathStart) {
                    node = this.asChild(new Node<V>(node, Type.EXACT, path.substring(pathStart, i)));
                }
                pathStart = i + 1;
                node = c == '*' ? this.asChild(new Node<V>(node, Type.CATCH_ALL, "*")) : this.asChild(new Node<V>(node, Type.PARAMETER, ":"));
            }
            if (pathStart < max) {
                node = this.asChild(new Node<V>(node, Type.EXACT, path.substring(pathStart)));
            }
            assert (node != null);
            ((Node)node).addValue(value, this.comparator);
            return node;
        }

        private Node<V> asChild(Node<V> child) {
            Node<V> parent = child.parent();
            return parent == null ? child : ((Node)parent).addChild(child);
        }
    }
}

