/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.util.EventLoopGroups;
import com.linecorp.armeria.common.util.StartStopSupport;
import com.linecorp.armeria.internal.ChannelUtil;
import com.linecorp.armeria.internal.ConnectionLimitingHandler;
import com.linecorp.armeria.internal.PathAndQuery;
import com.linecorp.armeria.internal.TransportType;
import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.GracefulShutdownSupport;
import com.linecorp.armeria.server.HttpServerPipelineConfigurator;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.ServiceCallbackInvoker;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainNameMapping;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Server
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private final ServerConfig config;
    @Nullable
    private final DomainNameMapping<SslContext> sslContexts;
    private final StartStopSupport<Void, ServerListener> startStop;
    private final Set<Channel> serverChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<InetSocketAddress, ServerPort> activePorts = new ConcurrentHashMap<InetSocketAddress, ServerPort>();
    private final Map<InetSocketAddress, ServerPort> unmodifiableActivePorts = Collections.unmodifiableMap(this.activePorts);
    private final ConnectionLimitingHandler connectionLimitingHandler;
    @Nullable
    private volatile ServerPort primaryActivePort;
    @Nullable
    private ServerBootstrap serverBootstrap;

    Server(ServerConfig config, @Nullable DomainNameMapping<SslContext> sslContexts) {
        this.config = Objects.requireNonNull(config, "config");
        this.sslContexts = sslContexts;
        this.startStop = new ServerStartStopSupport(config.startStopExecutor());
        this.connectionLimitingHandler = new ConnectionLimitingHandler(config.maxNumConnections());
        config.setServer(this);
        MeterIdPrefix idPrefix = new MeterIdPrefix("armeria.server.parsedPathCache");
        PathAndQuery.registerMetrics(config.meterRegistry(), idPrefix);
        config.serviceConfigs().forEach(cfg -> ServiceCallbackInvoker.invokeServiceAdded(cfg, cfg.service()));
    }

    public ServerConfig config() {
        return this.config;
    }

    public String defaultHostname() {
        return this.config().defaultVirtualHost().defaultHostname();
    }

    public Map<InetSocketAddress, ServerPort> activePorts() {
        return this.unmodifiableActivePorts;
    }

    public Optional<ServerPort> activePort() {
        return Optional.ofNullable(this.primaryActivePort);
    }

    @Nullable
    ServerBootstrap serverBootstrap() {
        return this.serverBootstrap;
    }

    public MeterRegistry meterRegistry() {
        return this.config().meterRegistry();
    }

    public void addListener(ServerListener listener) {
        this.startStop.addListener(Objects.requireNonNull(listener, "listener"));
    }

    public boolean removeListener(ServerListener listener) {
        return this.startStop.removeListener(Objects.requireNonNull(listener, "listener"));
    }

    public CompletableFuture<Void> start() {
        return this.startStop.start(true);
    }

    public CompletableFuture<Void> stop() {
        return this.startStop.stop();
    }

    public EventLoop nextEventLoop() {
        return this.config().workerGroup().next();
    }

    @Override
    public void close() {
        this.startStop.close();
    }

    public int numConnections() {
        return this.connectionLimitingHandler.numConnections();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("config", this.config()).add("activePorts", this.activePorts()).add("state", this.startStop).toString();
    }

    private static String bossThreadName(ServerPort port) {
        InetSocketAddress localAddr = port.localAddress();
        String localHostName = localAddr.getAddress().isAnyLocalAddress() ? "*" : localAddr.getHostString();
        String protocolNames = port.protocols().stream().map(SessionProtocol::uriText).collect(Collectors.joining("+"));
        return "armeria-boss-" + protocolNames + '-' + localHostName + ':' + localAddr.getPort();
    }

    private final class ServerPortStartListener
    implements ChannelFutureListener {
        private final AtomicInteger remainingPorts;
        private final CompletableFuture<Void> startFuture;
        private final ServerPort port;

        ServerPortStartListener(AtomicInteger remainingPorts, CompletableFuture<Void> startFuture, ServerPort port) {
            this.remainingPorts = Objects.requireNonNull(remainingPorts, "remainingPorts");
            this.startFuture = Objects.requireNonNull(startFuture, "startFuture");
            this.port = Objects.requireNonNull(port, "port");
        }

        public void operationComplete(ChannelFuture f) {
            Channel ch = f.channel();
            assert (ch.eventLoop().inEventLoop());
            if (this.startFuture.isDone()) {
                return;
            }
            if (f.isSuccess()) {
                Server.this.serverChannels.add(ch);
                ch.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> Server.this.serverChannels.remove(future.channel())));
                InetSocketAddress localAddress = (InetSocketAddress)ch.localAddress();
                ServerPort actualPort = new ServerPort(localAddress, this.port.protocols());
                Thread.currentThread().setName(Server.bossThreadName(actualPort));
                Server.this.activePorts.put(localAddress, actualPort);
                if (Server.this.primaryActivePort == null) {
                    Server.this.primaryActivePort = actualPort;
                }
                if (logger.isInfoEnabled()) {
                    if (localAddress.getAddress().isAnyLocalAddress() || localAddress.getAddress().isLoopbackAddress()) {
                        this.port.protocols().forEach(p -> logger.info("Serving {} at {} - {}://127.0.0.1:{}/", new Object[]{p.name(), localAddress, p.uriText(), localAddress.getPort()}));
                    } else {
                        logger.info("Serving {} at {}", (Object)Joiner.on('+').join(this.port.protocols()), (Object)localAddress);
                    }
                }
                if (this.remainingPorts.decrementAndGet() == 0) {
                    this.startFuture.complete(null);
                }
            } else {
                this.startFuture.completeExceptionally(f.cause());
            }
        }
    }

    private final class ServerStartStopSupport
    extends StartStopSupport<Void, ServerListener> {
        @Nullable
        private volatile GracefulShutdownSupport gracefulShutdownSupport;

        ServerStartStopSupport(Executor startStopExecutor) {
            super(startStopExecutor);
        }

        @Override
        protected CompletionStage<Void> doStart() {
            this.gracefulShutdownSupport = Server.this.config().gracefulShutdownQuietPeriod().isZero() ? GracefulShutdownSupport.createDisabled() : GracefulShutdownSupport.create(Server.this.config().gracefulShutdownQuietPeriod(), Server.this.config().blockingTaskExecutor());
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            List<ServerPort> ports = Server.this.config().ports();
            AtomicInteger remainingPorts = new AtomicInteger(ports.size());
            for (ServerPort p : ports) {
                this.doStart(p).addListener((GenericFutureListener)new ServerPortStartListener(remainingPorts, future, p));
            }
            this.setupServerMetrics();
            return future;
        }

        private ChannelFuture doStart(ServerPort port) {
            ServerBootstrap b = new ServerBootstrap();
            Server.this.serverBootstrap = b;
            Server.this.config.channelOptions().forEach((k, v) -> {
                ChannelOption castOption = k;
                b.option(castOption, v);
            });
            Server.this.config.childChannelOptions().forEach((k, v) -> {
                ChannelOption castOption = k;
                b.childOption(castOption, v);
            });
            b.group(EventLoopGroups.newEventLoopGroup(1, r -> {
                FastThreadLocalThread thread = new FastThreadLocalThread(r, Server.bossThreadName(port));
                thread.setDaemon(false);
                return thread;
            }), Server.this.config.workerGroup());
            b.channel(TransportType.detectTransportType().serverChannelClass());
            b.handler((ChannelHandler)Server.this.connectionLimitingHandler);
            b.childHandler((ChannelHandler)new HttpServerPipelineConfigurator(Server.this.config, port, (DomainNameMapping<SslContext>)Server.this.sslContexts, this.gracefulShutdownSupport));
            return b.bind((SocketAddress)port.localAddress());
        }

        private void setupServerMetrics() {
            MeterRegistry meterRegistry = Server.this.config().meterRegistry();
            GracefulShutdownSupport gracefulShutdownSupport = this.gracefulShutdownSupport;
            assert (gracefulShutdownSupport != null);
            meterRegistry.gauge("armeria.server.pendingResponses", (Object)gracefulShutdownSupport, GracefulShutdownSupport::pendingResponses);
            meterRegistry.gauge("armeria.server.connections", (Object)Server.this.connectionLimitingHandler, ConnectionLimitingHandler::numConnections);
        }

        @Override
        protected CompletionStage<Void> doStop() {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            GracefulShutdownSupport gracefulShutdownSupport = this.gracefulShutdownSupport;
            if (gracefulShutdownSupport == null || gracefulShutdownSupport.completedQuietPeriod()) {
                this.doStop(future, null);
                return future;
            }
            ScheduledExecutorService gracefulShutdownExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "armeria-shutdown-0x" + Integer.toHexString(this.hashCode())));
            ScheduledFuture<?> quietPeriodFuture = gracefulShutdownExecutor.scheduleAtFixedRate(() -> {
                if (gracefulShutdownSupport.completedQuietPeriod()) {
                    this.doStop(future, gracefulShutdownExecutor);
                }
            }, 0L, 100L, TimeUnit.MILLISECONDS);
            try {
                gracefulShutdownExecutor.schedule(() -> {
                    quietPeriodFuture.cancel(false);
                    this.doStop(future, gracefulShutdownExecutor);
                }, Server.this.config.gracefulShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            return future;
        }

        private void doStop(CompletableFuture<Void> future, @Nullable ExecutorService gracefulShutdownExecutor) {
            if (gracefulShutdownExecutor != null) {
                gracefulShutdownExecutor.shutdownNow();
            }
            ImmutableSet serverChannels = ImmutableSet.copyOf(Server.this.serverChannels);
            ChannelUtil.close(serverChannels).whenComplete((unused1, unused2) -> {
                Server.this.primaryActivePort = null;
                Server.this.activePorts.clear();
                ChannelUtil.close(Server.this.connectionLimitingHandler.children()).whenComplete((unused3, unused4) -> {
                    Future workerShutdownFuture = Server.this.config.shutdownWorkerGroupOnStop() ? Server.this.config.workerGroup().shutdownGracefully() : ImmediateEventExecutor.INSTANCE.newSucceededFuture(null);
                    workerShutdownFuture.addListener(unused5 -> {
                        if (serverChannels.size() == 0) {
                            this.finishDoStop(future);
                            return;
                        }
                        AtomicInteger remainingBossGroups = new AtomicInteger(serverChannels.size());
                        serverChannels.forEach(ch -> {
                            EventLoopGroup bossGroup = ch.eventLoop().parent();
                            bossGroup.shutdownGracefully();
                            bossGroup.terminationFuture().addListener(unused6 -> {
                                if (remainingBossGroups.decrementAndGet() != 0) {
                                    return;
                                }
                                this.finishDoStop(future);
                            });
                        });
                    });
                });
            });
        }

        private void finishDoStop(CompletableFuture<Void> future) {
            if (!Server.this.config.shutdownAccessLogWriterOnStop()) {
                future.complete(null);
                return;
            }
            ((CompletableFuture)Server.this.config.accessLogWriter().shutdown().exceptionally(cause -> {
                logger.warn("Failed to close the {}:", (Object)AccessLogWriter.class.getSimpleName(), cause);
                return null;
            })).thenRunAsync(() -> future.complete(null), Server.this.config.startStopExecutor());
        }

        @Override
        protected void notifyStarting(ServerListener listener) throws Exception {
            listener.serverStarting(Server.this);
        }

        @Override
        protected void notifyStarted(ServerListener listener, @Nullable Void value) throws Exception {
            listener.serverStarted(Server.this);
        }

        @Override
        protected void notifyStopping(ServerListener listener) throws Exception {
            listener.serverStopping(Server.this);
        }

        @Override
        protected void notifyStopped(ServerListener listener) throws Exception {
            listener.serverStopped(Server.this);
        }

        @Override
        protected void rollbackFailed(Throwable cause) {
            this.logStopFailure(cause);
        }

        @Override
        protected void notificationFailed(ServerListener listener, Throwable cause) {
            logger.warn("Failed to notify a server listener: {}", (Object)listener, (Object)cause);
        }

        @Override
        protected void closeFailed(Throwable cause) {
            this.logStopFailure(cause);
        }

        private void logStopFailure(Throwable cause) {
            logger.warn("Failed to stop a server: {}", (Object)cause.getMessage(), (Object)cause);
        }
    }
}

