/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectArrayMap;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.ChainedVirtualHostBuilder;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.RejectedPathMappingHandler;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceWithPathMappings;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainNameMapping;
import io.netty.util.DomainNameMappingBuilder;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class ServerBuilder {
    private static final Duration DEFAULT_GRACEFUL_SHUTDOWN_QUIET_PERIOD = Duration.ZERO;
    private static final Duration DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT = Duration.ZERO;
    private static final String DEFAULT_SERVICE_LOGGER_PREFIX = "armeria.services";
    private static final int PROXY_PROTOCOL_DEFAULT_MAX_TLV_SIZE = 65319;
    private static final Set<ChannelOption<?>> PROHIBITED_SOCKET_OPTIONS = ImmutableSet.of(ChannelOption.ALLOW_HALF_CLOSURE, ChannelOption.AUTO_READ, ChannelOption.AUTO_CLOSE, ChannelOption.MAX_MESSAGES_PER_READ, ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, new ChannelOption[]{EpollChannelOption.EPOLL_MODE});
    private final List<ServerPort> ports = new ArrayList<ServerPort>();
    private final List<ServerListener> serverListeners = new ArrayList<ServerListener>();
    private final List<VirtualHost> virtualHosts = new ArrayList<VirtualHost>();
    private final List<ChainedVirtualHostBuilder> virtualHostBuilders = new ArrayList<ChainedVirtualHostBuilder>();
    private final ChainedVirtualHostBuilder defaultVirtualHostBuilder = new ChainedVirtualHostBuilder(this);
    private boolean updatedDefaultVirtualHostBuilder;
    private RejectedPathMappingHandler rejectedPathMappingHandler = RejectedPathMappingHandler.WARN;
    @Nullable
    private VirtualHost defaultVirtualHost;
    private EventLoopGroup workerGroup = CommonPools.workerGroup();
    private boolean shutdownWorkerGroupOnStop;
    private Executor startStopExecutor = GlobalEventExecutor.INSTANCE;
    private final Map<ChannelOption<?>, Object> channelOptions = new Object2ObjectArrayMap();
    private final Map<ChannelOption<?>, Object> childChannelOptions = new Object2ObjectArrayMap();
    private int maxNumConnections = Flags.maxNumConnections();
    private long idleTimeoutMillis = Flags.defaultServerIdleTimeoutMillis();
    private long defaultRequestTimeoutMillis = Flags.defaultRequestTimeoutMillis();
    private long defaultMaxRequestLength = Flags.defaultMaxRequestLength();
    private int http2InitialConnectionWindowSize = Flags.defaultHttp2InitialConnectionWindowSize();
    private int http2InitialStreamWindowSize = Flags.defaultHttp2InitialStreamWindowSize();
    private long http2MaxStreamsPerConnection = Flags.defaultHttp2MaxStreamsPerConnection();
    private int http2MaxFrameSize = Flags.defaultHttp2MaxFrameSize();
    private long http2MaxHeaderListSize = Flags.defaultHttp2MaxHeaderListSize();
    private int http1MaxInitialLineLength = Flags.defaultHttp1MaxInitialLineLength();
    private int http1MaxHeaderSize = Flags.defaultHttp1MaxHeaderSize();
    private int http1MaxChunkSize = Flags.defaultHttp1MaxChunkSize();
    private int proxyProtocolMaxTlvSize = 65319;
    private Duration gracefulShutdownQuietPeriod = DEFAULT_GRACEFUL_SHUTDOWN_QUIET_PERIOD;
    private Duration gracefulShutdownTimeout = DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT;
    private Executor blockingTaskExecutor = CommonPools.blockingTaskExecutor();
    private MeterRegistry meterRegistry = Metrics.globalRegistry;
    private String serviceLoggerPrefix = "armeria.services";
    private AccessLogWriter accessLogWriter = AccessLogWriter.disabled();
    private boolean shutdownAccessLogWriterOnStop = true;
    @Nullable
    private Function<Service<HttpRequest, HttpResponse>, Service<HttpRequest, HttpResponse>> decorator;

    public ServerBuilder http(int port) {
        return this.port(new ServerPort(port, SessionProtocol.HTTP));
    }

    public ServerBuilder http(InetSocketAddress localAddress) {
        return this.port(new ServerPort(Objects.requireNonNull(localAddress, "localAddress"), SessionProtocol.HTTP));
    }

    public ServerBuilder https(int port) {
        return this.port(new ServerPort(port, SessionProtocol.HTTPS));
    }

    public ServerBuilder https(InetSocketAddress localAddress) {
        return this.port(new ServerPort(Objects.requireNonNull(localAddress, "localAddress"), SessionProtocol.HTTPS));
    }

    @Deprecated
    public ServerBuilder port(int port, String protocol) {
        return this.port(port, SessionProtocol.of(Objects.requireNonNull(protocol, "protocol")));
    }

    public ServerBuilder port(int port, SessionProtocol ... protocols) {
        return this.port(new ServerPort(port, protocols));
    }

    public ServerBuilder port(int port, Iterable<SessionProtocol> protocols) {
        return this.port(new ServerPort(port, protocols));
    }

    @Deprecated
    public ServerBuilder port(InetSocketAddress localAddress, String protocol) {
        return this.port(localAddress, SessionProtocol.of(Objects.requireNonNull(protocol, "protocol")));
    }

    public ServerBuilder port(InetSocketAddress localAddress, SessionProtocol ... protocols) {
        return this.port(new ServerPort(localAddress, protocols));
    }

    public ServerBuilder port(InetSocketAddress localAddress, Iterable<SessionProtocol> protocols) {
        return this.port(new ServerPort(localAddress, protocols));
    }

    public ServerBuilder port(ServerPort port) {
        Objects.requireNonNull(port, "port");
        if (port.localAddress().getPort() != 0) {
            this.ports.forEach(p -> Preconditions.checkArgument(!p.localAddress().equals(port.localAddress()), "duplicate local address: %s", (Object)port.localAddress()));
        }
        this.ports.add(port);
        return this;
    }

    public <T> ServerBuilder channelOption(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Preconditions.checkArgument(!PROHIBITED_SOCKET_OPTIONS.contains(option), "prohibited socket option: %s", option);
        option.validate(value);
        this.channelOptions.put(option, value);
        return this;
    }

    public <T> ServerBuilder childChannelOption(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Preconditions.checkArgument(!PROHIBITED_SOCKET_OPTIONS.contains(option), "prohibited socket option: %s", option);
        option.validate(value);
        this.childChannelOptions.put(option, value);
        return this;
    }

    public ServerBuilder virtualHost(VirtualHost virtualHost) {
        this.virtualHosts.add(Objects.requireNonNull(virtualHost, "virtualHost"));
        return this;
    }

    public ServerBuilder workerGroup(EventLoopGroup workerGroup, boolean shutdownOnStop) {
        this.workerGroup = Objects.requireNonNull(workerGroup, "workerGroup");
        this.shutdownWorkerGroupOnStop = shutdownOnStop;
        return this;
    }

    public ServerBuilder startStopExecutor(Executor startStopExecutor) {
        this.startStopExecutor = Objects.requireNonNull(startStopExecutor, "startStopExecutor");
        return this;
    }

    public ServerBuilder maxNumConnections(int maxNumConnections) {
        this.maxNumConnections = ServerConfig.validateMaxNumConnections(maxNumConnections);
        return this;
    }

    int maxNumConnections() {
        return this.maxNumConnections;
    }

    public ServerBuilder idleTimeoutMillis(long idleTimeoutMillis) {
        return this.idleTimeout(Duration.ofMillis(idleTimeoutMillis));
    }

    public ServerBuilder idleTimeout(Duration idleTimeout) {
        Objects.requireNonNull(idleTimeout, "idleTimeout");
        this.idleTimeoutMillis = ServerConfig.validateIdleTimeoutMillis(idleTimeout.toMillis());
        return this;
    }

    public ServerBuilder defaultRequestTimeoutMillis(long defaultRequestTimeoutMillis) {
        this.defaultRequestTimeoutMillis = ServerConfig.validateDefaultRequestTimeoutMillis(defaultRequestTimeoutMillis);
        return this;
    }

    public ServerBuilder defaultRequestTimeout(Duration defaultRequestTimeout) {
        return this.defaultRequestTimeoutMillis(Objects.requireNonNull(defaultRequestTimeout, "defaultRequestTimeout").toMillis());
    }

    public ServerBuilder defaultMaxRequestLength(long defaultMaxRequestLength) {
        this.defaultMaxRequestLength = ServerConfig.validateDefaultMaxRequestLength(defaultMaxRequestLength);
        return this;
    }

    public ServerBuilder http2InitialConnectionWindowSize(int http2InitialConnectionWindowSize) {
        Preconditions.checkArgument(http2InitialConnectionWindowSize > 0, "http2InitialConnectionWindowSize: %s (expected: > 0)", http2InitialConnectionWindowSize);
        this.http2InitialConnectionWindowSize = http2InitialConnectionWindowSize;
        return this;
    }

    public ServerBuilder http2InitialStreamWindowSize(int http2InitialStreamWindowSize) {
        Preconditions.checkArgument(http2InitialStreamWindowSize > 0, "http2InitialStreamWindowSize: %s (expected: > 0)", http2InitialStreamWindowSize);
        this.http2InitialStreamWindowSize = http2InitialStreamWindowSize;
        return this;
    }

    public ServerBuilder http2MaxStreamsPerConnection(long http2MaxStreamsPerConnection) {
        Preconditions.checkArgument(http2MaxStreamsPerConnection > 0L && http2MaxStreamsPerConnection <= 0xFFFFFFFFL, "http2MaxStreamsPerConnection: %s (expected: a positive 32-bit unsigned integer)", http2MaxStreamsPerConnection);
        this.http2MaxStreamsPerConnection = http2MaxStreamsPerConnection;
        return this;
    }

    public ServerBuilder http2MaxFrameSize(int http2MaxFrameSize) {
        Preconditions.checkArgument(http2MaxFrameSize >= 16384 && http2MaxFrameSize <= 0xFFFFFF, "http2MaxFramSize: %s (expected: >= %s and <= %s)", (Object)http2MaxFrameSize, (Object)16384, (Object)0xFFFFFF);
        this.http2MaxFrameSize = http2MaxFrameSize;
        return this;
    }

    public ServerBuilder http2MaxHeaderListSize(long http2MaxHeaderListSize) {
        Preconditions.checkArgument(http2MaxHeaderListSize > 0L && http2MaxHeaderListSize <= 0xFFFFFFFFL, "http2MaxHeaderListSize: %s (expected: a positive 32-bit unsigned integer)", http2MaxHeaderListSize);
        this.http2MaxHeaderListSize = http2MaxHeaderListSize;
        return this;
    }

    public ServerBuilder http1MaxInitialLineLength(int http1MaxInitialLineLength) {
        this.http1MaxInitialLineLength = ServerConfig.validateNonNegative(http1MaxInitialLineLength, "http1MaxInitialLineLength");
        return this;
    }

    public ServerBuilder http1MaxHeaderSize(int http1MaxHeaderSize) {
        this.http1MaxHeaderSize = ServerConfig.validateNonNegative(http1MaxHeaderSize, "http1MaxHeaderSize");
        return this;
    }

    public ServerBuilder http1MaxChunkSize(int http1MaxChunkSize) {
        this.http1MaxChunkSize = ServerConfig.validateNonNegative(http1MaxChunkSize, "http1MaxChunkSize");
        return this;
    }

    public ServerBuilder gracefulShutdownTimeout(long quietPeriodMillis, long timeoutMillis) {
        return this.gracefulShutdownTimeout(Duration.ofMillis(quietPeriodMillis), Duration.ofMillis(timeoutMillis));
    }

    public ServerBuilder gracefulShutdownTimeout(Duration quietPeriod, Duration timeout) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        Objects.requireNonNull(timeout, "timeout");
        this.gracefulShutdownQuietPeriod = ServerConfig.validateNonNegative(quietPeriod, "quietPeriod");
        this.gracefulShutdownTimeout = ServerConfig.validateNonNegative(timeout, "timeout");
        ServerConfig.validateGreaterThanOrEqual(this.gracefulShutdownTimeout, "quietPeriod", this.gracefulShutdownQuietPeriod, "timeout");
        return this;
    }

    public ServerBuilder blockingTaskExecutor(Executor blockingTaskExecutor) {
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        return this;
    }

    public ServerBuilder meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        return this;
    }

    public ServerBuilder serviceLoggerPrefix(String serviceLoggerPrefix) {
        this.serviceLoggerPrefix = ServiceConfig.validateLoggerName(serviceLoggerPrefix, "serviceLoggerPrefix");
        return this;
    }

    public ServerBuilder accessLogFormat(String accessLogFormat) {
        return this.accessLogWriter(AccessLogWriter.custom(Objects.requireNonNull(accessLogFormat, "accessLogFormat")), true);
    }

    public ServerBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.accessLogWriter = Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        this.shutdownAccessLogWriterOnStop = shutdownOnStop;
        return this;
    }

    public ServerBuilder proxyProtocolMaxTlvSize(int proxyProtocolMaxTlvSize) {
        Preconditions.checkArgument(proxyProtocolMaxTlvSize >= 0, "proxyProtocolMaxTlvSize: %s (expected: >= 0)", proxyProtocolMaxTlvSize);
        this.proxyProtocolMaxTlvSize = proxyProtocolMaxTlvSize;
        return this;
    }

    public ServerBuilder tls(SslContext sslContext) {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.tls(sslContext);
        return this;
    }

    public ServerBuilder tls(File keyCertChainFile, File keyFile) throws SSLException {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.tls(keyCertChainFile, keyFile);
        return this;
    }

    public ServerBuilder tls(File keyCertChainFile, File keyFile, @Nullable String keyPassword) throws SSLException {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.tls(keyCertChainFile, keyFile, keyPassword);
        return this;
    }

    public ServerBuilder tlsSelfSigned() throws SSLException, CertificateException {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.tlsSelfSigned();
        return this;
    }

    @Deprecated
    public ServerBuilder sslContext(SslContext sslContext) {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.tls(sslContext);
        return this;
    }

    @Deprecated
    public ServerBuilder sslContext(SessionProtocol protocol, File keyCertChainFile, File keyFile) throws SSLException {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.sslContext(protocol, keyCertChainFile, keyFile);
        return this;
    }

    @Deprecated
    public ServerBuilder sslContext(SessionProtocol protocol, File keyCertChainFile, File keyFile, String keyPassword) throws SSLException {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.sslContext(protocol, keyCertChainFile, keyFile, keyPassword);
        return this;
    }

    @Deprecated
    public ServerBuilder serviceAt(String pathPattern, Service<HttpRequest, HttpResponse> service) {
        return this.service(pathPattern, service);
    }

    public ServerBuilder serviceUnder(String pathPrefix, Service<HttpRequest, HttpResponse> service) {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.serviceUnder(pathPrefix, service);
        return this;
    }

    public ServerBuilder service(String pathPattern, Service<HttpRequest, HttpResponse> service) {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.service(pathPattern, service);
        return this;
    }

    public ServerBuilder service(PathMapping pathMapping, Service<HttpRequest, HttpResponse> service) {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.service(pathMapping, service);
        return this;
    }

    @Deprecated
    public ServerBuilder service(PathMapping pathMapping, Service<HttpRequest, HttpResponse> service, String loggerName) {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.service(pathMapping, service, loggerName);
        return this;
    }

    public <T extends ServiceWithPathMappings<HttpRequest, HttpResponse>> ServerBuilder service(T serviceWithPathMappings) {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.service(serviceWithPathMappings);
        return this;
    }

    public <T extends ServiceWithPathMappings<HttpRequest, HttpResponse>, R extends Service<HttpRequest, HttpResponse>> ServerBuilder service(T serviceWithPathMappings, Function<? super T, R> decorator) {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.service(serviceWithPathMappings, decorator);
        return this;
    }

    public ServerBuilder annotatedService(Object service) {
        return this.annotatedService("/", service, Function.identity(), ImmutableList.of());
    }

    public ServerBuilder annotatedService(Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, Function.identity(), Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters"));
    }

    public ServerBuilder annotatedService(Object service, Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, decorator, Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters"));
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service) {
        return this.annotatedService(pathPrefix, service, Function.identity(), ImmutableList.of());
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, Function.identity(), Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters"));
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service, Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public ServerBuilder annotatedService(String pathPrefix, Object service, Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator, Iterable<?> exceptionHandlersAndConverters) {
        this.defaultVirtualHostBuilderUpdated();
        this.defaultVirtualHostBuilder.annotatedService(pathPrefix, service, decorator, exceptionHandlersAndConverters);
        return this;
    }

    private void defaultVirtualHostBuilderUpdated() {
        this.updatedDefaultVirtualHostBuilder = true;
        if (this.defaultVirtualHost != null) {
            throw new IllegalStateException("ServerBuilder.defaultVirtualHost() invoked already.");
        }
    }

    public ServerBuilder defaultVirtualHost(VirtualHost defaultVirtualHost) {
        Objects.requireNonNull(defaultVirtualHost, "defaultVirtualHost");
        if (this.updatedDefaultVirtualHostBuilder) {
            throw new IllegalStateException("invoked other default VirtualHost builder methods already");
        }
        this.defaultVirtualHost = defaultVirtualHost;
        return this;
    }

    public ServerBuilder serverListener(ServerListener serverListener) {
        Objects.requireNonNull(serverListener, "serverListener");
        this.serverListeners.add(serverListener);
        return this;
    }

    public ChainedVirtualHostBuilder withDefaultVirtualHost() {
        this.defaultVirtualHostBuilderUpdated();
        return this.defaultVirtualHostBuilder;
    }

    public ChainedVirtualHostBuilder withVirtualHost(String hostnamePattern) {
        ChainedVirtualHostBuilder virtualHostBuilder = new ChainedVirtualHostBuilder(hostnamePattern, this);
        this.virtualHostBuilders.add(virtualHostBuilder);
        return virtualHostBuilder;
    }

    public ChainedVirtualHostBuilder withVirtualHost(String defaultHostname, String hostnamePattern) {
        ChainedVirtualHostBuilder virtualHostBuilder = new ChainedVirtualHostBuilder(defaultHostname, hostnamePattern, this);
        this.virtualHostBuilders.add(virtualHostBuilder);
        return virtualHostBuilder;
    }

    public <T extends Service<HttpRequest, HttpResponse>, R extends Service<HttpRequest, HttpResponse>> ServerBuilder decorator(Function<T, R> decorator) {
        Objects.requireNonNull(decorator, "decorator");
        Function<T, R> castDecorator = decorator;
        this.decorator = this.decorator != null ? this.decorator.andThen(castDecorator) : castDecorator;
        return this;
    }

    public ServerBuilder rejectedPathMappingHandler(RejectedPathMappingHandler handler) {
        this.rejectedPathMappingHandler = Objects.requireNonNull(handler, "handler");
        return this;
    }

    public Server build() {
        ImmutableList<ServerPort> ports;
        DomainNameMapping sslContexts;
        VirtualHost defaultVirtualHost = this.defaultVirtualHost != null ? this.defaultVirtualHost.decorate(this.decorator) : this.defaultVirtualHostBuilder.build().decorate(this.decorator);
        this.virtualHostBuilders.forEach(vhb -> this.virtualHosts.add(vhb.build()));
        List<VirtualHost> virtualHosts = this.decorator != null ? this.virtualHosts.stream().map(h -> h.decorate(this.decorator)).collect(Collectors.toList()) : this.virtualHosts;
        SslContext defaultSslContext = ServerBuilder.findDefaultSslContext(defaultVirtualHost, virtualHosts);
        this.ports.forEach(port -> Preconditions.checkState(port.protocols().stream().anyMatch(p -> p != SessionProtocol.PROXY), "protocols: %s (expected: at least one %s or %s)", port.protocols(), (Object)SessionProtocol.HTTP, (Object)SessionProtocol.HTTPS));
        if (defaultSslContext == null) {
            sslContexts = null;
            if (!this.ports.isEmpty()) {
                ports = ImmutableList.copyOf(this.ports);
                for (ServerPort p : ports) {
                    if (!p.hasTls()) continue;
                    throw new IllegalArgumentException("TLS not configured; cannot serve HTTPS");
                }
            } else {
                ports = ImmutableList.of(new ServerPort(0, SessionProtocol.HTTP));
            }
        } else {
            ports = !this.ports.isEmpty() ? ImmutableList.copyOf(this.ports) : ImmutableList.of(new ServerPort(0, SessionProtocol.HTTPS));
            DomainNameMappingBuilder mappingBuilder = new DomainNameMappingBuilder((Object)defaultSslContext);
            for (VirtualHost h2 : virtualHosts) {
                SslContext sslCtx = h2.sslContext();
                if (sslCtx == null) continue;
                mappingBuilder.add(h2.hostnamePattern(), (Object)sslCtx);
            }
            sslContexts = mappingBuilder.build();
        }
        Server server = new Server(new ServerConfig(ports, this.normalizeDefaultVirtualHost(defaultVirtualHost, defaultSslContext), virtualHosts, this.workerGroup, this.shutdownWorkerGroupOnStop, this.startStopExecutor, this.maxNumConnections, this.idleTimeoutMillis, this.defaultRequestTimeoutMillis, this.defaultMaxRequestLength, this.http2InitialConnectionWindowSize, this.http2InitialStreamWindowSize, this.http2MaxStreamsPerConnection, this.http2MaxFrameSize, this.http2MaxHeaderListSize, this.http1MaxInitialLineLength, this.http1MaxHeaderSize, this.http1MaxChunkSize, this.gracefulShutdownQuietPeriod, this.gracefulShutdownTimeout, this.blockingTaskExecutor, this.meterRegistry, this.serviceLoggerPrefix, this.accessLogWriter, this.shutdownAccessLogWriterOnStop, this.proxyProtocolMaxTlvSize, this.channelOptions, this.childChannelOptions), (DomainNameMapping<SslContext>)sslContexts);
        this.serverListeners.forEach(server::addListener);
        return server;
    }

    private VirtualHost normalizeDefaultVirtualHost(VirtualHost h, @Nullable SslContext defaultSslContext) {
        SslContext sslCtx = h.sslContext() != null ? h.sslContext() : defaultSslContext;
        return new VirtualHost(h.defaultHostname(), "*", sslCtx, h.serviceConfigs().stream().map(e -> new ServiceConfig(e.pathMapping(), (Service<HttpRequest, HttpResponse>)e.service(), e.loggerName().orElse(null))).collect(Collectors.toList()), h.producibleMediaTypes(), this.rejectedPathMappingHandler);
    }

    @Nullable
    private static SslContext findDefaultSslContext(VirtualHost defaultVirtualHost, List<VirtualHost> virtualHosts) {
        SslContext lastSslContext = null;
        for (VirtualHost h : virtualHosts) {
            if (h.sslContext() == null) continue;
            lastSslContext = h.sslContext();
        }
        if (defaultVirtualHost.sslContext() != null) {
            lastSslContext = defaultVirtualHost.sslContext();
        }
        return lastSslContext;
    }

    public String toString() {
        return ServerConfig.toString(this.getClass(), this.ports, this.defaultVirtualHost, this.virtualHosts, this.workerGroup, this.shutdownWorkerGroupOnStop, this.maxNumConnections, this.idleTimeoutMillis, this.defaultRequestTimeoutMillis, this.defaultMaxRequestLength, this.http2InitialConnectionWindowSize, this.http2InitialStreamWindowSize, this.http2MaxStreamsPerConnection, this.http2MaxFrameSize, this.http2MaxHeaderListSize, this.http1MaxInitialLineLength, this.http1MaxHeaderSize, this.http1MaxChunkSize, this.proxyProtocolMaxTlvSize, this.gracefulShutdownQuietPeriod, this.gracefulShutdownTimeout, this.blockingTaskExecutor, this.meterRegistry, this.serviceLoggerPrefix, this.accessLogWriter, this.shutdownAccessLogWriterOnStop, this.channelOptions, this.childChannelOptions);
    }
}

