/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.ConnectionLimitingHandler;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectArrayMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ExecutorBasedExecutorService;
import com.linecorp.armeria.server.InterminableExecutorService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.DomainNameMapping;
import io.netty.util.DomainNameMappingBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public final class ServerConfig {
    @Nullable
    private Server server;
    private final List<ServerPort> ports;
    private final VirtualHost defaultVirtualHost;
    private final List<VirtualHost> virtualHosts;
    private final DomainNameMapping<VirtualHost> virtualHostMapping;
    private final List<ServiceConfig> services;
    private final EventLoopGroup workerGroup;
    private final boolean shutdownWorkerGroupOnStop;
    private final Executor startStopExecutor;
    private final int maxNumConnections;
    private final long defaultRequestTimeoutMillis;
    private final long idleTimeoutMillis;
    private final long defaultMaxRequestLength;
    private final int http2InitialConnectionWindowSize;
    private final int http2InitialStreamWindowSize;
    private final long http2MaxStreamsPerConnection;
    private final int http2MaxFrameSize;
    private final long http2MaxHeaderListSize;
    private final int http1MaxInitialLineLength;
    private final int http1MaxHeaderSize;
    private final int http1MaxChunkSize;
    private final Duration gracefulShutdownQuietPeriod;
    private final Duration gracefulShutdownTimeout;
    private final ExecutorService blockingTaskExecutor;
    private final MeterRegistry meterRegistry;
    private final String serviceLoggerPrefix;
    private final AccessLogWriter accessLogWriter;
    private final boolean shutdownAccessLogWriterOnStop;
    private final int proxyProtocolMaxTlvSize;
    private final Map<ChannelOption<?>, ?> channelOptions;
    private final Map<ChannelOption<?>, ?> childChannelOptions;
    @Nullable
    private String strVal;

    ServerConfig(Iterable<ServerPort> ports, VirtualHost defaultVirtualHost, Iterable<VirtualHost> virtualHosts, EventLoopGroup workerGroup, boolean shutdownWorkerGroupOnStop, Executor startStopExecutor, int maxNumConnections, long idleTimeoutMillis, long defaultRequestTimeoutMillis, long defaultMaxRequestLength, int http2InitialConnectionWindowSize, int http2InitialStreamWindowSize, long http2MaxStreamsPerConnection, int http2MaxFrameSize, long http2MaxHeaderListSize, int http1MaxInitialLineLength, int http1MaxHeaderSize, int http1MaxChunkSize, Duration gracefulShutdownQuietPeriod, Duration gracefulShutdownTimeout, Executor blockingTaskExecutor, MeterRegistry meterRegistry, String serviceLoggerPrefix, AccessLogWriter accessLogWriter, boolean shutdownAccessLogWriterOnStop, int proxyProtocolMaxTlvSize, Map<ChannelOption<?>, Object> channelOptions, Map<ChannelOption<?>, Object> childChannelOptions) {
        Objects.requireNonNull(ports, "ports");
        Objects.requireNonNull(defaultVirtualHost, "defaultVirtualHost");
        Objects.requireNonNull(virtualHosts, "virtualHosts");
        this.workerGroup = Objects.requireNonNull(workerGroup, "workerGroup");
        this.shutdownWorkerGroupOnStop = shutdownWorkerGroupOnStop;
        this.startStopExecutor = Objects.requireNonNull(startStopExecutor, "startStopExecutor");
        this.maxNumConnections = ServerConfig.validateMaxNumConnections(maxNumConnections);
        this.idleTimeoutMillis = ServerConfig.validateIdleTimeoutMillis(idleTimeoutMillis);
        this.defaultRequestTimeoutMillis = ServerConfig.validateDefaultRequestTimeoutMillis(defaultRequestTimeoutMillis);
        this.defaultMaxRequestLength = ServerConfig.validateDefaultMaxRequestLength(defaultMaxRequestLength);
        this.http2InitialConnectionWindowSize = http2InitialConnectionWindowSize;
        this.http2InitialStreamWindowSize = http2InitialStreamWindowSize;
        this.http2MaxStreamsPerConnection = http2MaxStreamsPerConnection;
        this.http2MaxFrameSize = http2MaxFrameSize;
        this.http2MaxHeaderListSize = http2MaxHeaderListSize;
        this.http1MaxInitialLineLength = ServerConfig.validateNonNegative(http1MaxInitialLineLength, "http1MaxInitialLineLength");
        this.http1MaxHeaderSize = ServerConfig.validateNonNegative(http1MaxHeaderSize, "http1MaxHeaderSize");
        this.http1MaxChunkSize = ServerConfig.validateNonNegative(http1MaxChunkSize, "http1MaxChunkSize");
        this.gracefulShutdownQuietPeriod = ServerConfig.validateNonNegative(Objects.requireNonNull(gracefulShutdownQuietPeriod), "gracefulShutdownQuietPeriod");
        this.gracefulShutdownTimeout = ServerConfig.validateNonNegative(Objects.requireNonNull(gracefulShutdownTimeout), "gracefulShutdownTimeout");
        ServerConfig.validateGreaterThanOrEqual(gracefulShutdownTimeout, "gracefulShutdownTimeout", gracefulShutdownQuietPeriod, "gracefulShutdownQuietPeriod");
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.blockingTaskExecutor = blockingTaskExecutor instanceof ExecutorService ? new InterminableExecutorService((ExecutorService)blockingTaskExecutor) : new ExecutorBasedExecutorService(blockingTaskExecutor);
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        this.serviceLoggerPrefix = ServiceConfig.validateLoggerName(serviceLoggerPrefix, "serviceLoggerPrefix");
        this.accessLogWriter = Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        this.shutdownAccessLogWriterOnStop = shutdownAccessLogWriterOnStop;
        this.channelOptions = Collections.unmodifiableMap(new Object2ObjectArrayMap(Objects.requireNonNull(channelOptions, "channelOptions")));
        this.childChannelOptions = Collections.unmodifiableMap(new Object2ObjectArrayMap(Objects.requireNonNull(childChannelOptions, "childChannelOptions")));
        ArrayList<ServerPort> portsCopy = new ArrayList<ServerPort>();
        for (ServerPort p : ports) {
            if (p == null) break;
            portsCopy.add(p);
        }
        if (portsCopy.isEmpty()) {
            throw new IllegalArgumentException("no ports in the server");
        }
        this.ports = Collections.unmodifiableList(portsCopy);
        this.proxyProtocolMaxTlvSize = this.ports.stream().anyMatch(ServerPort::hasProxyProtocol) ? proxyProtocolMaxTlvSize : 0;
        DomainNameMappingBuilder mappingBuilder = new DomainNameMappingBuilder((Object)defaultVirtualHost);
        ArrayList<VirtualHost> virtualHostsCopy = new ArrayList<VirtualHost>();
        for (VirtualHost h2 : virtualHosts) {
            if (h2 == null) break;
            virtualHostsCopy.add(h2);
            mappingBuilder.add(h2.hostnamePattern(), (Object)h2);
        }
        this.virtualHostMapping = mappingBuilder.build();
        virtualHostsCopy.add(defaultVirtualHost);
        virtualHostsCopy.forEach(h -> h.setServerConfig(this));
        if (virtualHostsCopy.stream().allMatch(h -> h.serviceConfigs().isEmpty())) {
            throw new IllegalArgumentException("no services in the server");
        }
        this.virtualHosts = Collections.unmodifiableList(virtualHostsCopy);
        this.defaultVirtualHost = defaultVirtualHost;
        this.services = virtualHostsCopy.stream().flatMap(h -> h.serviceConfigs().stream()).collect(ImmutableList.toImmutableList());
    }

    static int validateMaxNumConnections(int maxNumConnections) {
        return ConnectionLimitingHandler.validateMaxNumConnections(maxNumConnections);
    }

    static long validateIdleTimeoutMillis(long idleTimeoutMillis) {
        if (idleTimeoutMillis < 0L) {
            throw new IllegalArgumentException("idleTimeoutMillis: " + idleTimeoutMillis + " (expected: >= 0)");
        }
        return idleTimeoutMillis;
    }

    static long validateDefaultRequestTimeoutMillis(long defaultRequestTimeoutMillis) {
        if (defaultRequestTimeoutMillis < 0L) {
            throw new IllegalArgumentException("defaultRequestTimeoutMillis: " + defaultRequestTimeoutMillis + " (expected: >= 0)");
        }
        return defaultRequestTimeoutMillis;
    }

    static long validateDefaultMaxRequestLength(long defaultMaxRequestLength) {
        if (defaultMaxRequestLength < 0L) {
            throw new IllegalArgumentException("defaultMaxRequestLength: " + defaultMaxRequestLength + " (expected: >= 0)");
        }
        return defaultMaxRequestLength;
    }

    static int validateNonNegative(int value, String fieldName) {
        if (value < 0) {
            throw new IllegalArgumentException(fieldName + ": " + value + " (expected: >= 0)");
        }
        return value;
    }

    static Duration validateNonNegative(Duration duration, String fieldName) {
        if (duration.isNegative()) {
            throw new IllegalArgumentException(fieldName + ": " + duration + " (expected: >= 0)");
        }
        return duration;
    }

    static void validateGreaterThanOrEqual(Duration larger, String largerFieldName, Duration smaller, String smallerFieldName) {
        if (larger.compareTo(smaller) < 0) {
            throw new IllegalArgumentException(largerFieldName + " must be greater than or equal to" + smallerFieldName);
        }
    }

    public Server server() {
        if (this.server == null) {
            throw new IllegalStateException("Server has not been configured yet.");
        }
        return this.server;
    }

    void setServer(Server server) {
        if (this.server != null) {
            throw new IllegalStateException("ServerConfig cannot be used for more than one Server.");
        }
        this.server = Objects.requireNonNull(server, "server");
    }

    public List<ServerPort> ports() {
        return this.ports;
    }

    public VirtualHost defaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public List<VirtualHost> virtualHosts() {
        return this.virtualHosts;
    }

    public VirtualHost findVirtualHost(String hostname) {
        return (VirtualHost)this.virtualHostMapping.map(hostname);
    }

    public List<VirtualHost> findVirtualHosts(Service<?, ?> service) {
        Objects.requireNonNull(service, "service");
        Class<?> serviceType = service.getClass();
        ArrayList<VirtualHost> res = new ArrayList<VirtualHost>();
        block0: for (VirtualHost h : this.virtualHosts) {
            for (ServiceConfig c : h.serviceConfigs()) {
                Object s = c.service();
                Optional<?> sOpt = s.as(serviceType);
                if (!sOpt.isPresent() || sOpt.get() != service) continue;
                res.add(c.virtualHost());
                continue block0;
            }
        }
        return res;
    }

    public List<ServiceConfig> serviceConfigs() {
        return this.services;
    }

    public EventLoopGroup workerGroup() {
        return this.workerGroup;
    }

    public boolean shutdownWorkerGroupOnStop() {
        return this.shutdownWorkerGroupOnStop;
    }

    Executor startStopExecutor() {
        return this.startStopExecutor;
    }

    public Map<ChannelOption<?>, ?> channelOptions() {
        return this.channelOptions;
    }

    public Map<ChannelOption<?>, ?> childChannelOptions() {
        return this.childChannelOptions;
    }

    public int maxNumConnections() {
        return this.maxNumConnections;
    }

    public long idleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public long defaultRequestTimeoutMillis() {
        return this.defaultRequestTimeoutMillis;
    }

    public long defaultMaxRequestLength() {
        return this.defaultMaxRequestLength;
    }

    public int http1MaxInitialLineLength() {
        return this.http1MaxInitialLineLength;
    }

    public int http1MaxHeaderSize() {
        return this.http1MaxHeaderSize;
    }

    public int http1MaxChunkSize() {
        return this.http1MaxChunkSize;
    }

    public int http2InitialConnectionWindowSize() {
        return this.http2InitialConnectionWindowSize;
    }

    public int http2InitialStreamWindowSize() {
        return this.http2InitialStreamWindowSize;
    }

    public long http2MaxStreamsPerConnection() {
        return this.http2MaxStreamsPerConnection;
    }

    public int http2MaxFrameSize() {
        return this.http2MaxFrameSize;
    }

    public long http2MaxHeaderListSize() {
        return this.http2MaxHeaderListSize;
    }

    public Duration gracefulShutdownQuietPeriod() {
        return this.gracefulShutdownQuietPeriod;
    }

    public Duration gracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    public ExecutorService blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    public String serviceLoggerPrefix() {
        return this.serviceLoggerPrefix;
    }

    public AccessLogWriter accessLogWriter() {
        return this.accessLogWriter;
    }

    public boolean shutdownAccessLogWriterOnStop() {
        return this.shutdownAccessLogWriterOnStop;
    }

    public int proxyProtocolMaxTlvSize() {
        return this.proxyProtocolMaxTlvSize;
    }

    public String toString() {
        String strVal = this.strVal;
        if (strVal == null) {
            this.strVal = strVal = ServerConfig.toString(this.getClass(), this.ports(), null, this.virtualHosts(), this.workerGroup(), this.shutdownWorkerGroupOnStop(), this.maxNumConnections(), this.idleTimeoutMillis(), this.defaultRequestTimeoutMillis(), this.defaultMaxRequestLength(), this.http2InitialConnectionWindowSize(), this.http2InitialStreamWindowSize(), this.http2MaxStreamsPerConnection(), this.http2MaxFrameSize(), this.http2MaxHeaderListSize(), this.http1MaxInitialLineLength(), this.http1MaxHeaderSize(), this.http1MaxChunkSize(), this.proxyProtocolMaxTlvSize(), this.gracefulShutdownQuietPeriod(), this.gracefulShutdownTimeout(), this.blockingTaskExecutor(), this.meterRegistry(), this.serviceLoggerPrefix(), this.accessLogWriter(), this.shutdownAccessLogWriterOnStop(), this.channelOptions(), this.childChannelOptions());
        }
        return strVal;
    }

    static String toString(@Nullable Class<?> type, Iterable<ServerPort> ports, @Nullable VirtualHost defaultVirtualHost, List<VirtualHost> virtualHosts, EventLoopGroup workerGroup, boolean shutdownWorkerGroupOnStop, int maxNumConnections, long idleTimeoutMillis, long defaultRequestTimeoutMillis, long defaultMaxRequestLength, int http2InitialConnectionWindowSize, int http2InitialStreamWindowSize, long http2MaxStreamsPerConnection, int http2MaxFrameSize, long http2MaxHeaderListSize, long http1MaxInitialLineLength, long http1MaxHeaderSize, long http1MaxChunkSize, int proxyProtocolMaxTlvSize, Duration gracefulShutdownQuietPeriod, Duration gracefulShutdownTimeout, Executor blockingTaskExecutor, @Nullable MeterRegistry meterRegistry, String serviceLoggerPrefix, AccessLogWriter accessLogWriter, boolean shutdownAccessLogWriterOnStop, Map<ChannelOption<?>, ?> channelOptions, Map<ChannelOption<?>, ?> childChannelOptions) {
        StringBuilder buf = new StringBuilder();
        if (type != null) {
            buf.append(type.getSimpleName());
        }
        buf.append("(ports: [");
        boolean hasPorts = false;
        for (ServerPort p : ports) {
            buf.append(ServerPort.toString(null, p.localAddress(), p.protocols()));
            buf.append(", ");
            hasPorts = true;
        }
        if (hasPorts) {
            buf.setCharAt(buf.length() - 2, ']');
            buf.setCharAt(buf.length() - 1, ',');
        } else {
            buf.append("],");
        }
        buf.append(" virtualHosts: [");
        if (!virtualHosts.isEmpty()) {
            virtualHosts.forEach(c -> {
                buf.append(VirtualHost.toString(null, c.defaultHostname(), c.hostnamePattern(), c.sslContext(), c.serviceConfigs()));
                buf.append(", ");
            });
            if (defaultVirtualHost != null) {
                buf.append(VirtualHost.toString(null, defaultVirtualHost.defaultHostname(), "*", defaultVirtualHost.sslContext(), defaultVirtualHost.serviceConfigs()));
            } else {
                buf.setLength(buf.length() - 2);
            }
        } else if (defaultVirtualHost != null) {
            buf.append(VirtualHost.toString(null, defaultVirtualHost.defaultHostname(), "*", defaultVirtualHost.sslContext(), defaultVirtualHost.serviceConfigs()));
        }
        buf.append("], workerGroup: ");
        buf.append(workerGroup);
        buf.append(" (shutdownOnStop=");
        buf.append(shutdownWorkerGroupOnStop);
        buf.append("), maxNumConnections: ");
        buf.append(maxNumConnections);
        buf.append(", idleTimeout: ");
        buf.append(idleTimeoutMillis);
        buf.append("ms, defaultRequestTimeout: ");
        buf.append(defaultRequestTimeoutMillis);
        buf.append("ms, defaultMaxRequestLength: ");
        buf.append(defaultMaxRequestLength);
        buf.append("B, http2InitialConnectionWindowSize: ");
        buf.append(http2InitialConnectionWindowSize);
        buf.append("B, http2InitialStreamWindowSize: ");
        buf.append(http2InitialStreamWindowSize);
        buf.append("B, http2MaxStreamsPerConnection: ");
        buf.append(http2MaxStreamsPerConnection);
        buf.append(", http2MaxFrameSize: ");
        buf.append(http2MaxFrameSize);
        buf.append("B, http2MaxHeaderListSize: ");
        buf.append(http2MaxHeaderListSize);
        buf.append("B, http1MaxInitialLineLength: ");
        buf.append(http1MaxInitialLineLength);
        buf.append("B, http1MaxHeaderSize: ");
        buf.append(http1MaxHeaderSize);
        buf.append("B, http1MaxChunkSize: ");
        buf.append(http1MaxChunkSize);
        buf.append("B, proxyProtocolMaxTlvSize: ");
        buf.append(proxyProtocolMaxTlvSize);
        buf.append("B, gracefulShutdownQuietPeriod: ");
        buf.append(gracefulShutdownQuietPeriod);
        buf.append(", gracefulShutdownTimeout: ");
        buf.append(gracefulShutdownTimeout);
        buf.append(", blockingTaskExecutor: ");
        buf.append(blockingTaskExecutor);
        if (meterRegistry != null) {
            buf.append(", meterRegistry: ");
            buf.append(meterRegistry);
        }
        buf.append(", serviceLoggerPrefix: ");
        buf.append(serviceLoggerPrefix);
        buf.append(", accessLogWriter: ");
        buf.append(accessLogWriter);
        buf.append(", shutdownAccessLogWriterOnStop: ");
        buf.append(shutdownAccessLogWriterOnStop);
        buf.append(')');
        buf.append(", channelOptions: ");
        buf.append(channelOptions);
        buf.append(", childChannelOptions: ");
        buf.append(childChannelOptions);
        return buf.toString();
    }
}

