/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class ServerListenerBuilder {
    private final List<Consumer<? super Server>> serverStartingCallbacks = new ArrayList<Consumer<? super Server>>();
    private final List<Consumer<? super Server>> serverStartedCallbacks = new ArrayList<Consumer<? super Server>>();
    private final List<Consumer<? super Server>> serverStoppingCallbacks = new ArrayList<Consumer<? super Server>>();
    private final List<Consumer<? super Server>> serverStoppedCallbacks = new ArrayList<Consumer<? super Server>>();

    public ServerListenerBuilder addStartingCallback(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        this.serverStartingCallbacks.add(unused -> runnable.run());
        return this;
    }

    public ServerListenerBuilder addStartingCallback(Consumer<? super Server> consumer) {
        this.serverStartingCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        return this;
    }

    @SafeVarargs
    public final ServerListenerBuilder addStartingCallbacks(Consumer<? super Server> ... consumers) {
        return this.addStartingCallbacks(Arrays.asList(consumers));
    }

    public ServerListenerBuilder addStartingCallbacks(Iterable<Consumer<? super Server>> consumers) {
        Objects.requireNonNull(consumers, "consumers");
        for (Consumer<? super Server> consumer : consumers) {
            this.serverStartingCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        }
        return this;
    }

    public ServerListenerBuilder addStartedCallback(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        this.serverStartedCallbacks.add(unused -> runnable.run());
        return this;
    }

    public ServerListenerBuilder addStartedCallback(Consumer<? super Server> consumer) {
        this.serverStartedCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        return this;
    }

    @SafeVarargs
    public final ServerListenerBuilder addStartedCallbacks(Consumer<? super Server> ... consumers) {
        return this.addStartedCallbacks(Arrays.asList(consumers));
    }

    public ServerListenerBuilder addStartedCallbacks(Iterable<Consumer<? super Server>> consumers) {
        Objects.requireNonNull(consumers, "consumers");
        for (Consumer<? super Server> consumer : consumers) {
            this.serverStartedCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        }
        return this;
    }

    public ServerListenerBuilder addStoppingCallback(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        this.serverStoppingCallbacks.add(unused -> runnable.run());
        return this;
    }

    public ServerListenerBuilder addStoppingCallback(Consumer<? super Server> consumer) {
        this.serverStoppingCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        return this;
    }

    @SafeVarargs
    public final ServerListenerBuilder addStoppingCallbacks(Consumer<? super Server> ... consumers) {
        return this.addStoppingCallbacks(Arrays.asList(consumers));
    }

    public ServerListenerBuilder addStoppingCallbacks(Iterable<Consumer<? super Server>> consumers) {
        Objects.requireNonNull(consumers, "consumers");
        for (Consumer<? super Server> consumer : consumers) {
            this.serverStoppingCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        }
        return this;
    }

    public ServerListenerBuilder addStoppedCallback(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        this.serverStoppedCallbacks.add(unused -> runnable.run());
        return this;
    }

    public ServerListenerBuilder addStoppedCallback(Consumer<? super Server> consumer) {
        this.serverStoppedCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        return this;
    }

    @SafeVarargs
    public final ServerListenerBuilder addStoppedCallbacks(Consumer<? super Server> ... consumers) {
        return this.addStoppedCallbacks(Arrays.asList(consumers));
    }

    public ServerListenerBuilder addStoppedCallbacks(Iterable<Consumer<? super Server>> consumers) {
        Objects.requireNonNull(consumers, "consumers");
        for (Consumer<? super Server> consumer : consumers) {
            this.serverStoppedCallbacks.add(Objects.requireNonNull(consumer, "consumer"));
        }
        return this;
    }

    public ServerListener build() {
        return new CallbackServerListener(this.serverStartingCallbacks, this.serverStartedCallbacks, this.serverStoppingCallbacks, this.serverStoppedCallbacks);
    }

    private static class CallbackServerListener
    implements ServerListener {
        private final List<Consumer<? super Server>> serverStartingCallbacks;
        private final List<Consumer<? super Server>> serverStartedCallbacks;
        private final List<Consumer<? super Server>> serverStoppingCallbacks;
        private final List<Consumer<? super Server>> serverStoppedCallbacks;

        CallbackServerListener(List<Consumer<? super Server>> serverStartingCallbacks, List<Consumer<? super Server>> serverStartedCallbacks, List<Consumer<? super Server>> serverStoppingCallbacks, List<Consumer<? super Server>> serverStoppedCallbacks) {
            this.serverStartingCallbacks = ImmutableList.copyOf(serverStartingCallbacks);
            this.serverStartedCallbacks = ImmutableList.copyOf(serverStartedCallbacks);
            this.serverStoppingCallbacks = ImmutableList.copyOf(serverStoppingCallbacks);
            this.serverStoppedCallbacks = ImmutableList.copyOf(serverStoppedCallbacks);
        }

        @Override
        public void serverStarting(Server server) {
            for (Consumer<? super Server> serverStartingCallback : this.serverStartingCallbacks) {
                serverStartingCallback.accept(server);
            }
        }

        @Override
        public void serverStarted(Server server) {
            for (Consumer<? super Server> serverStartedCallback : this.serverStartedCallbacks) {
                serverStartedCallback.accept(server);
            }
        }

        @Override
        public void serverStopping(Server server) {
            for (Consumer<? super Server> serverStoppingCallback : this.serverStoppingCallbacks) {
                serverStoppingCallback.accept(server);
            }
        }

        @Override
        public void serverStopped(Server server) {
            for (Consumer<? super Server> serverStoppedCallback : this.serverStoppedCallbacks) {
                serverStoppedCallback.accept(server);
            }
        }
    }
}

