/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class ServerPort
implements Comparable<ServerPort> {
    private final InetSocketAddress localAddress;
    private final String comparisonStr;
    private final Set<SessionProtocol> protocols;
    private int hashCode;
    @Nullable
    private String strVal;

    public ServerPort(int port, SessionProtocol ... protocols) {
        this(new InetSocketAddress(port), ImmutableSet.copyOf(Objects.requireNonNull(protocols, "protocols")));
    }

    public ServerPort(InetSocketAddress localAddress, SessionProtocol ... protocols) {
        this(localAddress, ImmutableSet.copyOf(Objects.requireNonNull(protocols, "protocols")));
    }

    public ServerPort(int port, Iterable<SessionProtocol> protocols) {
        this(new InetSocketAddress(port), protocols);
    }

    public ServerPort(InetSocketAddress localAddress, Iterable<SessionProtocol> protocols) {
        if (Objects.requireNonNull(localAddress, "localAddress").isUnresolved()) {
            try {
                localAddress = new InetSocketAddress(InetAddress.getByName(localAddress.getHostString()), localAddress.getPort());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("unresolved localAddress: " + localAddress, e);
            }
        }
        Objects.requireNonNull(protocols, "protocols");
        this.localAddress = localAddress;
        this.protocols = Sets.immutableEnumSet(protocols);
        Preconditions.checkArgument(!this.protocols.isEmpty(), "protocols: %s (must not be empty)", this.protocols);
        Preconditions.checkArgument(this.protocols.contains((Object)SessionProtocol.HTTP) || this.protocols.contains((Object)SessionProtocol.HTTPS), "protocols: %s (must contain HTTP or HTTPS)", this.protocols);
        Preconditions.checkArgument(this.protocols.stream().allMatch(p -> p == SessionProtocol.HTTP || p == SessionProtocol.HTTPS || p == SessionProtocol.PROXY), "protocols: %s (must not contain other than %s, %s or %s)", this.protocols, (Object)SessionProtocol.HTTP, (Object)SessionProtocol.HTTPS, (Object)SessionProtocol.PROXY);
        this.comparisonStr = localAddress.getAddress().getHostAddress() + '/' + localAddress.getPort() + '/' + protocols;
    }

    public InetSocketAddress localAddress() {
        return this.localAddress;
    }

    @Deprecated
    public SessionProtocol protocol() {
        return Iterables.getFirst(this.protocols, null);
    }

    public Set<SessionProtocol> protocols() {
        return this.protocols;
    }

    public boolean hasTls() {
        return this.protocols.stream().anyMatch(SessionProtocol::isTls);
    }

    public boolean hasHttp() {
        return this.hasProtocol(SessionProtocol.HTTP) || this.hasProtocol(SessionProtocol.H1C) || this.hasProtocol(SessionProtocol.H2C);
    }

    public boolean hasHttps() {
        return this.hasProtocol(SessionProtocol.HTTPS) || this.hasProtocol(SessionProtocol.H1) || this.hasProtocol(SessionProtocol.H2);
    }

    public boolean hasProxyProtocol() {
        return this.hasProtocol(SessionProtocol.PROXY);
    }

    public boolean hasProtocol(SessionProtocol protocol) {
        return this.protocols.contains((Object)Objects.requireNonNull(protocol, "protocol"));
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = this.comparisonStr.hashCode();
            if (hashCode == 0) {
                hashCode = 1;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServerPort)) {
            return false;
        }
        ServerPort that = (ServerPort)obj;
        int hashCode = this.hashCode;
        if (hashCode != 0 && that.hashCode != 0 && hashCode != that.hashCode) {
            return false;
        }
        return this.comparisonStr.equals(that.comparisonStr);
    }

    @Override
    public int compareTo(ServerPort o) {
        return this.comparisonStr.compareTo(o.comparisonStr);
    }

    public String toString() {
        String strVal = this.strVal;
        if (strVal == null) {
            this.strVal = strVal = ServerPort.toString(this.getClass(), this.localAddress(), this.protocols());
        }
        return strVal;
    }

    static String toString(@Nullable Class<?> type, InetSocketAddress localAddress, Set<SessionProtocol> protocols) {
        StringBuilder buf = new StringBuilder();
        if (type != null) {
            buf.append(type.getSimpleName());
        }
        buf.append('(');
        buf.append(localAddress);
        buf.append(", ");
        buf.append(protocols);
        buf.append(')');
        return buf.toString();
    }
}

