/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.server.DecoratingServiceFunction;
import com.linecorp.armeria.server.FunctionalDecoratingService;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

@FunctionalInterface
public interface Service<I extends Request, O extends Response> {
    default public void serviceAdded(ServiceConfig cfg) throws Exception {
    }

    public O serve(ServiceRequestContext var1, I var2) throws Exception;

    default public <T> Optional<T> as(Class<T> serviceType) {
        Objects.requireNonNull(serviceType, "serviceType");
        return serviceType.isInstance(this) ? Optional.of(serviceType.cast(this)) : Optional.empty();
    }

    default public <R extends Service<?, ?>> R decorate(Class<R> serviceType) {
        Objects.requireNonNull(serviceType, "serviceType");
        Constructor<?> constructor = null;
        for (Constructor<?> c : serviceType.getConstructors()) {
            if (c.getParameterCount() != 1 || !c.getParameterTypes()[0].isAssignableFrom(this.getClass())) continue;
            constructor = c;
            break;
        }
        if (constructor == null) {
            throw new IllegalArgumentException("cannot find a matching constructor: " + serviceType.getName());
        }
        try {
            return (R)((Service)constructor.newInstance(this));
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to instantiate: " + serviceType.getName(), e);
        }
    }

    default public <T extends Service<I, O>, R extends Service<R_I, R_O>, R_I extends Request, R_O extends Response> R decorate(Function<T, R> decorator) {
        Service newService = (Service)decorator.apply(this);
        if (newService == null) {
            throw new NullPointerException("decorator.apply() returned null: " + decorator);
        }
        return (R)newService;
    }

    default public Service<I, O> decorate(DecoratingServiceFunction<I, O> function) {
        return new FunctionalDecoratingService<I, O>(this, function);
    }

    default public boolean shouldCachePath(String path, @Nullable String query, PathMapping pathMapping) {
        return pathMapping.exactPath().isPresent() && query == null;
    }
}

