/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.VirtualHost;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class ServiceConfig {
    private static final Pattern LOGGER_NAME_PATTERN = Pattern.compile("^\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*$");
    @Nullable
    private VirtualHost virtualHost;
    private final PathMapping pathMapping;
    @Nullable
    private final String loggerName;
    private final Service<HttpRequest, HttpResponse> service;

    public ServiceConfig(VirtualHost virtualHost, PathMapping pathMapping, Service<HttpRequest, HttpResponse> service) {
        this(virtualHost, pathMapping, service, null);
    }

    public ServiceConfig(VirtualHost virtualHost, PathMapping pathMapping, Service<HttpRequest, HttpResponse> service, @Nullable String loggerName) {
        this(pathMapping, service, loggerName);
        this.virtualHost = Objects.requireNonNull(virtualHost, "virtualHost");
    }

    ServiceConfig(PathMapping pathMapping, Service<HttpRequest, HttpResponse> service, @Nullable String loggerName) {
        this.pathMapping = Objects.requireNonNull(pathMapping, "pathMapping");
        this.service = Objects.requireNonNull(service, "service");
        this.loggerName = loggerName != null ? ServiceConfig.validateLoggerName(loggerName, "loggerName") : null;
    }

    static String validateLoggerName(String value, String propertyName) {
        Objects.requireNonNull(value, propertyName);
        if (!LOGGER_NAME_PATTERN.matcher(value).matches()) {
            throw new IllegalArgumentException(propertyName + ": " + value);
        }
        return value;
    }

    ServiceConfig build(VirtualHost virtualHost) {
        Objects.requireNonNull(virtualHost, "virtualHost");
        return new ServiceConfig(virtualHost, this.pathMapping(), (Service<HttpRequest, HttpResponse>)this.service());
    }

    public VirtualHost virtualHost() {
        if (this.virtualHost == null) {
            throw new IllegalStateException("Server has not been configured yet.");
        }
        return this.virtualHost;
    }

    public Server server() {
        return this.virtualHost().server();
    }

    public PathMapping pathMapping() {
        return this.pathMapping;
    }

    public <T extends Service<HttpRequest, HttpResponse>> T service() {
        return (T)this.service;
    }

    @Deprecated
    public Optional<String> loggerName() {
        return Optional.ofNullable(this.loggerName);
    }

    public String toString() {
        if (this.virtualHost != null) {
            return this.virtualHost.hostnamePattern() + ": " + this.pathMapping + " -> " + this.service;
        }
        return this.pathMapping + " -> " + this.service;
    }
}

