/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaTypeSet;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.server.PathMapped;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.RejectedPathMappingHandler;
import com.linecorp.armeria.server.Router;
import com.linecorp.armeria.server.Routers;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainNameMapping;
import io.netty.util.DomainNameMappingBuilder;
import java.net.IDN;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class VirtualHost {
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(?:[-_a-zA-Z0-9]|[-_a-zA-Z0-9][-_.a-zA-Z0-9]*[-_a-zA-Z0-9])$");
    @Nullable
    private ServerConfig serverConfig;
    private final String defaultHostname;
    private final String hostnamePattern;
    @Nullable
    private final SslContext sslContext;
    private final List<ServiceConfig> services;
    private final Router<ServiceConfig> router;
    private final MediaTypeSet producibleMediaTypes;
    @Nullable
    private String strVal;

    VirtualHost(String defaultHostname, String hostnamePattern, @Nullable SslContext sslContext, Iterable<ServiceConfig> serviceConfigs, MediaTypeSet producibleMediaTypes) {
        this(defaultHostname, hostnamePattern, sslContext, serviceConfigs, producibleMediaTypes, (virtualHost, mapping, existingMapping) -> {});
    }

    VirtualHost(String defaultHostname, String hostnamePattern, @Nullable SslContext sslContext, Iterable<ServiceConfig> serviceConfigs, MediaTypeSet producibleMediaTypes, RejectedPathMappingHandler rejectionHandler) {
        defaultHostname = VirtualHost.normalizeDefaultHostname(defaultHostname);
        hostnamePattern = VirtualHost.normalizeHostnamePattern(hostnamePattern);
        VirtualHost.ensureHostnamePatternMatchesDefaultHostname(hostnamePattern, defaultHostname);
        this.defaultHostname = defaultHostname;
        this.hostnamePattern = hostnamePattern;
        this.sslContext = VirtualHost.validateSslContext(sslContext);
        this.producibleMediaTypes = producibleMediaTypes;
        Objects.requireNonNull(serviceConfigs, "serviceConfigs");
        ArrayList<ServiceConfig> servicesCopy = new ArrayList<ServiceConfig>();
        for (ServiceConfig c : serviceConfigs) {
            c = c.build(this);
            servicesCopy.add(c);
        }
        this.services = Collections.unmodifiableList(servicesCopy);
        this.router = Routers.ofVirtualHost(this, this.services, rejectionHandler);
    }

    static String normalizeDefaultHostname(String defaultHostname) {
        Objects.requireNonNull(defaultHostname, "defaultHostname");
        if (VirtualHost.needsNormalization(defaultHostname)) {
            defaultHostname = IDN.toASCII(defaultHostname, 1);
        }
        if (!HOSTNAME_PATTERN.matcher(defaultHostname).matches()) {
            throw new IllegalArgumentException("defaultHostname: " + defaultHostname);
        }
        return Ascii.toLowerCase(defaultHostname);
    }

    static String normalizeHostnamePattern(String hostnamePattern) {
        Objects.requireNonNull(hostnamePattern, "hostnamePattern");
        if (VirtualHost.needsNormalization(hostnamePattern)) {
            hostnamePattern = IDN.toASCII(hostnamePattern, 1);
        }
        if (!"*".equals(hostnamePattern) && !HOSTNAME_PATTERN.matcher(hostnamePattern.startsWith("*.") ? hostnamePattern.substring(2) : hostnamePattern).matches()) {
            throw new IllegalArgumentException("hostnamePattern: " + hostnamePattern);
        }
        return Ascii.toLowerCase(hostnamePattern);
    }

    static void ensureHostnamePatternMatchesDefaultHostname(String hostnamePattern, String defaultHostname) {
        if ("*".equals(hostnamePattern)) {
            return;
        }
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)Boolean.FALSE).add(hostnamePattern, (Object)Boolean.TRUE).build();
        if (!((Boolean)mapping.map(defaultHostname)).booleanValue()) {
            throw new IllegalArgumentException("defaultHostname: " + defaultHostname + " (must be matched by hostnamePattern: " + hostnamePattern + ')');
        }
    }

    private static boolean needsNormalization(String hostnamePattern) {
        int length = hostnamePattern.length();
        for (int i = 0; i < length; ++i) {
            char c = hostnamePattern.charAt(i);
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    @Nullable
    static SslContext validateSslContext(@Nullable SslContext sslContext) {
        if (sslContext != null && !sslContext.isServer()) {
            throw new IllegalArgumentException("sslContext: " + sslContext + " (expected: server context)");
        }
        return sslContext;
    }

    public Server server() {
        if (this.serverConfig == null) {
            throw new IllegalStateException("server is not configured yet.");
        }
        return this.serverConfig.server();
    }

    void setServerConfig(ServerConfig serverConfig) {
        if (this.serverConfig != null) {
            throw new IllegalStateException("VirtualHost cannot be added to more than one Server.");
        }
        this.serverConfig = Objects.requireNonNull(serverConfig, "serverConfig");
        MeterRegistry registry = serverConfig.meterRegistry();
        MeterIdPrefix idPrefix = new MeterIdPrefix("armeria.server.router.virtualHostCache", "hostnamePattern", this.hostnamePattern);
        this.router.registerMetrics(registry, idPrefix);
    }

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public String hostnamePattern() {
        return this.hostnamePattern;
    }

    @Nullable
    public SslContext sslContext() {
        return this.sslContext;
    }

    public List<ServiceConfig> serviceConfigs() {
        return this.services;
    }

    public MediaTypeSet producibleMediaTypes() {
        return this.producibleMediaTypes;
    }

    public PathMapped<ServiceConfig> findServiceConfig(PathMappingContext mappingCtx) {
        Objects.requireNonNull(mappingCtx, "mappingCtx");
        return this.router.find(mappingCtx);
    }

    Router<ServiceConfig> router() {
        return this.router;
    }

    VirtualHost decorate(@Nullable Function<Service<HttpRequest, HttpResponse>, Service<HttpRequest, HttpResponse>> decorator) {
        if (decorator == null) {
            return this;
        }
        List<ServiceConfig> services = this.services.stream().map(cfg -> {
            PathMapping pathMapping = cfg.pathMapping();
            Service service = (Service)decorator.apply((Service<HttpRequest, HttpResponse>)cfg.service());
            String loggerName = cfg.loggerName().orElse(null);
            return new ServiceConfig(pathMapping, service, loggerName);
        }).collect(Collectors.toList());
        return new VirtualHost(this.defaultHostname(), this.hostnamePattern(), this.sslContext(), services, this.producibleMediaTypes());
    }

    public String toString() {
        String strVal = this.strVal;
        if (strVal == null) {
            this.strVal = strVal = VirtualHost.toString(this.getClass(), this.defaultHostname(), this.hostnamePattern(), this.sslContext(), this.serviceConfigs());
        }
        return strVal;
    }

    static String toString(@Nullable Class<?> type, String defaultHostname, String hostnamePattern, @Nullable SslContext sslContext, List<?> services) {
        StringBuilder buf = new StringBuilder();
        if (type != null) {
            buf.append(type.getSimpleName());
        }
        buf.append('(');
        buf.append(defaultHostname);
        buf.append('/');
        buf.append(hostnamePattern);
        buf.append(", ssl: ");
        buf.append(sslContext != null);
        buf.append(", services: ");
        buf.append(services);
        buf.append(')');
        return buf.toString();
    }
}

