/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import javax.annotation.Nullable;

public class ByteArrayResponseConverterFunction
implements ResponseConverterFunction {
    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, @Nullable Object result) throws Exception {
        if (result instanceof HttpData) {
            return HttpResponse.of(HttpStatus.OK, ByteArrayResponseConverterFunction.mediaType(ctx.negotiatedResponseMediaType()), ((HttpData)result).array());
        }
        if (result instanceof byte[]) {
            return HttpResponse.of(HttpStatus.OK, ByteArrayResponseConverterFunction.mediaType(ctx.negotiatedResponseMediaType()), (byte[])result);
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private static MediaType mediaType(@Nullable MediaType mediaType) {
        if (mediaType == null) {
            return MediaType.APPLICATION_BINARY;
        }
        if (mediaType.is(MediaType.APPLICATION_BINARY) || mediaType.is(MediaType.OCTET_STREAM)) {
            return mediaType;
        }
        return (MediaType)ResponseConverterFunction.fallthrough();
    }
}

