/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class JacksonRequestConverterFunction
implements RequestConverterFunction {
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper();
    private final ObjectMapper mapper;
    private final ConcurrentMap<Class<?>, ObjectReader> readers = new ConcurrentHashMap();

    public JacksonRequestConverterFunction() {
        this(defaultObjectMapper);
    }

    public JacksonRequestConverterFunction(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    @Nullable
    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpMessage request, Class<?> expectedResultType) throws Exception {
        block6: {
            ObjectReader reader;
            MediaType contentType;
            block7: {
                contentType = request.headers().contentType();
                if (contentType == null) break block6;
                if (contentType.is(MediaType.JSON)) break block7;
                if (!contentType.subtype().endsWith("+json")) break block6;
            }
            if ((reader = this.readers.computeIfAbsent(expectedResultType, arg_0 -> ((ObjectMapper)this.mapper).readerFor(arg_0))) != null) {
                String content = request.content().toString(contentType.charset().orElse(StandardCharsets.UTF_8));
                try {
                    return reader.readValue(content);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("failed to parse a JSON document: " + (Object)((Object)e), e);
                }
            }
        }
        return RequestConverterFunction.fallthrough();
    }
}

