/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;

public class JacksonResponseConverterFunction
implements ResponseConverterFunction {
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper();
    private final ObjectMapper mapper;

    public JacksonResponseConverterFunction() {
        this(defaultObjectMapper);
    }

    public JacksonResponseConverterFunction(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, @Nullable Object result) throws Exception {
        MediaType mediaType = ctx.negotiatedResponseMediaType();
        if (mediaType != null) {
            Charset charset;
            if ((mediaType.is(MediaType.JSON) || mediaType.subtype().endsWith("+json")) && (charset = mediaType.charset().orElse(StandardCharsets.UTF_8)).contains(StandardCharsets.UTF_8)) {
                return HttpResponse.of(HttpStatus.OK, mediaType.withCharset(StandardCharsets.UTF_8), this.mapper.writeValueAsBytes(result));
            }
        } else if (result instanceof JsonNode) {
            return HttpResponse.of(HttpStatus.OK, MediaType.JSON_UTF_8, this.mapper.writeValueAsBytes(result));
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }
}

