/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class StringResponseConverterFunction
implements ResponseConverterFunction {
    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, @Nullable Object result) throws Exception {
        MediaType mediaType = ctx.negotiatedResponseMediaType();
        if (mediaType != null) {
            if (mediaType.is(MediaType.ANY_TEXT_TYPE)) {
                Charset charset = mediaType.charset().orElse(StandardCharsets.UTF_8);
                return HttpResponse.of(HttpStatus.OK, mediaType.withCharset(charset), String.valueOf(result).getBytes(charset));
            }
        } else if (result instanceof CharSequence) {
            return HttpResponse.of(((CharSequence)result).toString());
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }
}

