/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthorizerUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@FunctionalInterface
public interface Authorizer<T> {
    public CompletionStage<Boolean> authorize(ServiceRequestContext var1, T var2);

    default public Authorizer<T> orElse(final Authorizer<T> nextAuthorizer) {
        final Authorizer self = this;
        return new Authorizer<T>(){
            @Nullable
            private String strVal;

            @Override
            public CompletionStage<Boolean> authorize(ServiceRequestContext ctx, T data) {
                return AuthorizerUtil.authorize(self, ctx, data).thenComposeAsync(result -> {
                    if (result == null) {
                        throw AuthorizerUtil.newNullResultException(self);
                    }
                    return result != false ? CompletableFuture.completedFuture(true) : AuthorizerUtil.authorize(nextAuthorizer, ctx, data);
                }, (Executor)ctx.contextAwareEventLoop());
            }

            public String toString() {
                String s;
                if (this.strVal != null) {
                    return this.strVal;
                }
                StringBuilder buf = new StringBuilder();
                if (self.getClass() == this.getClass()) {
                    s = self.toString();
                    buf.append(s, 0, s.length() - 1);
                } else {
                    buf.append('[').append(self);
                }
                buf.append(", ");
                if (nextAuthorizer.getClass() == this.getClass()) {
                    s = nextAuthorizer.toString();
                    buf.append(s, 1, s.length());
                } else {
                    buf.append(nextAuthorizer).append(']');
                }
                this.strVal = buf.toString();
                return this.strVal;
            }
        };
    }
}

