/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.internal.shaded.futures.CompletableFutures;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.Authorizer;
import java.util.concurrent.CompletionStage;

final class AuthorizerUtil {
    static <T> CompletionStage<Boolean> authorize(Authorizer<T> authorizer, ServiceRequestContext ctx, T data) {
        try {
            CompletionStage<Boolean> f = authorizer.authorize(ctx, data);
            if (f == null) {
                throw new NullPointerException("An " + Authorizer.class.getSimpleName() + " returned null: " + authorizer);
            }
            return f;
        }
        catch (Throwable cause) {
            return CompletableFutures.exceptionallyCompletedFuture(cause);
        }
    }

    static NullPointerException newNullResultException(Authorizer<?> authorizer) {
        return new NullPointerException("A future returned by an " + Authorizer.class.getSimpleName() + " has been fulfilled with null: " + authorizer);
    }

    private AuthorizerUtil() {
    }
}

