/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingService;
import com.linecorp.armeria.server.auth.AuthFailureHandler;
import com.linecorp.armeria.server.auth.AuthSuccessHandler;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.armeria.server.auth.AuthorizerUtil;
import com.linecorp.armeria.server.auth.HttpAuthServiceBuilder;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpAuthService
extends SimpleDecoratingService<HttpRequest, HttpResponse> {
    static final Logger logger = LoggerFactory.getLogger(HttpAuthService.class);
    private final Authorizer<HttpRequest> authorizer;
    private final AuthSuccessHandler<HttpRequest, HttpResponse> successHandler;
    private final AuthFailureHandler<HttpRequest, HttpResponse> failureHandler;

    public static Function<Service<HttpRequest, HttpResponse>, HttpAuthService> newDecorator(Iterable<? extends Authorizer<HttpRequest>> authorizers) {
        return new HttpAuthServiceBuilder().add(authorizers).newDecorator();
    }

    @SafeVarargs
    public static Function<Service<HttpRequest, HttpResponse>, HttpAuthService> newDecorator(Authorizer<HttpRequest> ... authorizers) {
        return HttpAuthService.newDecorator(ImmutableList.copyOf(Objects.requireNonNull(authorizers, "authorizers")));
    }

    HttpAuthService(Service<HttpRequest, HttpResponse> delegate, Authorizer<HttpRequest> authorizer, AuthSuccessHandler<HttpRequest, HttpResponse> successHandler, AuthFailureHandler<HttpRequest, HttpResponse> failureHandler) {
        super(delegate);
        this.authorizer = authorizer;
        this.successHandler = successHandler;
        this.failureHandler = failureHandler;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.from(AuthorizerUtil.authorize(this.authorizer, ctx, req).handleAsync((result, cause) -> {
            try {
                if (cause == null) {
                    if (result != null) {
                        return result != false ? this.successHandler.authSucceeded((Service<HttpRequest, HttpResponse>)this.delegate(), ctx, req) : this.failureHandler.authFailed((Service<HttpRequest, HttpResponse>)this.delegate(), ctx, req, null);
                    }
                    cause = AuthorizerUtil.newNullResultException(this.authorizer);
                }
                return this.failureHandler.authFailed((Service<HttpRequest, HttpResponse>)this.delegate(), ctx, req, (Throwable)cause);
            }
            catch (Exception e) {
                return (HttpResponse)Exceptions.throwUnsafely(e);
            }
        }, (Executor)ctx.contextAwareEventLoop()));
    }
}

