/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.auth.AuthFailureHandler;
import com.linecorp.armeria.server.auth.AuthSuccessHandler;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.armeria.server.auth.BasicToken;
import com.linecorp.armeria.server.auth.BasicTokenExtractor;
import com.linecorp.armeria.server.auth.HttpAuthService;
import com.linecorp.armeria.server.auth.OAuth1aToken;
import com.linecorp.armeria.server.auth.OAuth1aTokenExtractor;
import com.linecorp.armeria.server.auth.OAuth2Token;
import com.linecorp.armeria.server.auth.OAuth2TokenExtractor;
import io.netty.util.AsciiString;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HttpAuthServiceBuilder {
    @Nullable
    private Authorizer<HttpRequest> authorizer;
    private AuthSuccessHandler<HttpRequest, HttpResponse> successHandler = Service::serve;
    private AuthFailureHandler<HttpRequest, HttpResponse> failureHandler = (delegate, ctx, req, cause) -> {
        if (cause != null) {
            HttpAuthService.logger.warn("Unexpected exception during authorization.", cause);
        }
        return HttpResponse.of(HttpStatus.UNAUTHORIZED);
    };

    public HttpAuthServiceBuilder add(Authorizer<HttpRequest> authorizer) {
        Objects.requireNonNull(authorizer, "authorizer");
        this.authorizer = this.authorizer == null ? authorizer : this.authorizer.orElse(authorizer);
        return this;
    }

    public HttpAuthServiceBuilder add(Iterable<? extends Authorizer<HttpRequest>> authorizers) {
        Objects.requireNonNull(authorizers, "authorizers");
        authorizers.forEach(a -> {
            Objects.requireNonNull(a, "authorizers contains null.");
            this.add((Authorizer<HttpRequest>)a);
        });
        return this;
    }

    public HttpAuthServiceBuilder addBasicAuth(Authorizer<? super BasicToken> authorizer) {
        return this.addTokenAuthorizer(AuthTokenExtractors.BASIC, Objects.requireNonNull(authorizer, "authorizer"));
    }

    public HttpAuthServiceBuilder addBasicAuth(Authorizer<? super BasicToken> authorizer, AsciiString header) {
        return this.addTokenAuthorizer(new BasicTokenExtractor(Objects.requireNonNull(header, "header")), Objects.requireNonNull(authorizer, "authorizer"));
    }

    public HttpAuthServiceBuilder addOAuth1a(Authorizer<? super OAuth1aToken> authorizer) {
        return this.addTokenAuthorizer(AuthTokenExtractors.OAUTH1A, Objects.requireNonNull(authorizer, "authorizer"));
    }

    public HttpAuthServiceBuilder addOAuth1a(Authorizer<? super OAuth1aToken> authorizer, AsciiString header) {
        return this.addTokenAuthorizer(new OAuth1aTokenExtractor(Objects.requireNonNull(header, "header")), Objects.requireNonNull(authorizer, "authorizer"));
    }

    public HttpAuthServiceBuilder addOAuth2(Authorizer<? super OAuth2Token> authorizer) {
        return this.addTokenAuthorizer(AuthTokenExtractors.OAUTH2, Objects.requireNonNull(authorizer, "authorizer"));
    }

    public HttpAuthServiceBuilder addOAuth2(Authorizer<? super OAuth2Token> authorizer, AsciiString header) {
        return this.addTokenAuthorizer(new OAuth2TokenExtractor(Objects.requireNonNull(header, "header")), Objects.requireNonNull(authorizer, "authorizer"));
    }

    public <T> HttpAuthServiceBuilder addTokenAuthorizer(Function<HttpHeaders, T> tokenExtractor, Authorizer<? super T> authorizer) {
        Objects.requireNonNull(tokenExtractor, "tokenExtractor");
        Objects.requireNonNull(authorizer, "authorizer");
        Authorizer<HttpRequest> requestAuthorizer = (ctx, req) -> {
            Object token = tokenExtractor.apply(req.headers());
            if (token == null) {
                return CompletableFuture.completedFuture(false);
            }
            return authorizer.authorize(ctx, (Object)token);
        };
        this.add(requestAuthorizer);
        return this;
    }

    public HttpAuthServiceBuilder onSuccess(AuthSuccessHandler<HttpRequest, HttpResponse> successHandler) {
        this.successHandler = Objects.requireNonNull(successHandler, "successHandler");
        return this;
    }

    public HttpAuthServiceBuilder onFailure(AuthFailureHandler<HttpRequest, HttpResponse> failureHandler) {
        this.failureHandler = Objects.requireNonNull(failureHandler, "failureHandler");
        return this;
    }

    public HttpAuthService build(Service<HttpRequest, HttpResponse> delegate) {
        return new HttpAuthService(Objects.requireNonNull(delegate, "delegate"), this.authorizer(), this.successHandler, this.failureHandler);
    }

    public Function<Service<HttpRequest, HttpResponse>, HttpAuthService> newDecorator() {
        Authorizer<HttpRequest> authorizer = this.authorizer();
        AuthSuccessHandler<HttpRequest, HttpResponse> successHandler = this.successHandler;
        AuthFailureHandler<HttpRequest, HttpResponse> failureHandler = this.failureHandler;
        return service -> new HttpAuthService((Service<HttpRequest, HttpResponse>)service, authorizer, successHandler, failureHandler);
    }

    private Authorizer<HttpRequest> authorizer() {
        if (this.authorizer == null) {
            throw new IllegalStateException("no " + Authorizer.class.getSimpleName() + " was added.");
        }
        return this.authorizer;
    }
}

