/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import java.util.Map;
import java.util.Set;

public final class OAuth1aToken {
    private static final String REALM = "realm";
    private static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String OAUTH_TOKEN = "oauth_token";
    private static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String OAUTH_SIGNATURE = "oauth_signature";
    private static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String OAUTH_NONCE = "oauth_nonce";
    private static final String OAUTH_VERSION = "version";
    private static final Set<String> REQUIRED_PARAM_KEYS = ImmutableSet.of("oauth_consumer_key", "oauth_token", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce", new String[0]);
    private static final Set<String> OPTIONAL_PARAM_KEYS = ImmutableSet.of("realm", "version");
    private static final Set<String> DEFINED_PARAM_KEYS = Sets.union(REQUIRED_PARAM_KEYS, OPTIONAL_PARAM_KEYS);
    private final Map<String, String> params;

    public static OAuth1aToken of(Map<String, String> params) {
        return new OAuth1aToken(params);
    }

    private OAuth1aToken(Map<String, String> params) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            String key = param.getKey();
            String value = param.getValue();
            if (Strings.isNullOrEmpty(value)) continue;
            String lowerCased = Ascii.toLowerCase(key);
            if (DEFINED_PARAM_KEYS.contains(lowerCased)) {
                builder.put(lowerCased, value);
                continue;
            }
            builder.put(key, value);
        }
        this.params = builder.build();
        if (!this.params.keySet().containsAll(REQUIRED_PARAM_KEYS)) {
            Sets.SetView<String> missing = Sets.difference(REQUIRED_PARAM_KEYS, this.params.keySet());
            throw new IllegalArgumentException("Missing OAuth1a parameter exists: " + missing);
        }
        try {
            Long.parseLong(this.params.get(OAUTH_TIMESTAMP));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal oauth_timestamp value: " + this.params.get(OAUTH_TIMESTAMP));
        }
    }

    public String realm() {
        return this.params.get(REALM);
    }

    public String consumerKey() {
        return this.params.get(OAUTH_CONSUMER_KEY);
    }

    public String token() {
        return this.params.get(OAUTH_TOKEN);
    }

    public String signatureMethod() {
        return this.params.get(OAUTH_SIGNATURE_METHOD);
    }

    public String signature() {
        return this.params.get(OAUTH_SIGNATURE);
    }

    public String timestamp() {
        return this.params.get(OAUTH_TIMESTAMP);
    }

    public String nonce() {
        return this.params.get(OAUTH_NONCE);
    }

    public String version() {
        return this.params.getOrDefault(OAUTH_VERSION, "1.0");
    }

    public Map<String, String> additionals() {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> e : this.params.entrySet()) {
            if (DEFINED_PARAM_KEYS.contains(e.getKey())) continue;
            builder.put(e.getKey(), e.getValue());
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth1aToken that = (OAuth1aToken)o;
        return this.params.equals(that.params);
    }

    public int hashCode() {
        return this.params.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add(REALM, this.realm()).add("consumerKey", this.consumerKey()).add("token", "****").add("signatureMethod", this.signatureMethod()).add("signature", this.signature()).add("timestamp", this.timestamp()).add("nonce", this.nonce()).add(OAUTH_VERSION, this.version()).add("additionals", this.additionals()).toString();
    }
}

