/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.auth.OAuth1aToken;
import io.netty.util.AsciiString;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuth1aTokenExtractor
implements Function<HttpHeaders, OAuth1aToken> {
    private static final Logger logger = LoggerFactory.getLogger(OAuth1aTokenExtractor.class);
    private static final Pattern AUTHORIZATION_HEADER_PATTERN = Pattern.compile("\\s*(?i)oauth\\s+(?<parameters>\\S+)\\s*");
    private final AsciiString header;

    OAuth1aTokenExtractor(AsciiString header) {
        this.header = header;
    }

    @Override
    @Nullable
    public OAuth1aToken apply(HttpHeaders headers) {
        String authorization = (String)headers.get(this.header);
        if (Strings.isNullOrEmpty(authorization)) {
            return null;
        }
        Matcher matcher = AUTHORIZATION_HEADER_PATTERN.matcher(authorization);
        if (!matcher.matches()) {
            logger.warn("Invalid authorization header: " + authorization);
            return null;
        }
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (String token : matcher.group("parameters").split(",")) {
            int sep = token.indexOf(61);
            if (sep == -1 || token.charAt(sep + 1) != '\"' || token.charAt(token.length() - 1) != '\"') {
                logger.warn("Invalid token: " + token);
                return null;
            }
            String key = token.substring(0, sep);
            String value = token.substring(sep + 2, token.length() - 1);
            builder.put(key, value);
        }
        return OAuth1aToken.of(builder.build());
    }
}

