/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.server.auth.OAuth2Token;
import io.netty.util.AsciiString;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuth2TokenExtractor
implements Function<HttpHeaders, OAuth2Token> {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2TokenExtractor.class);
    private static final Pattern AUTHORIZATION_HEADER_PATTERN = Pattern.compile("\\s*(?i)bearer\\s+(?<accessToken>\\S+)\\s*");
    private final AsciiString header;

    OAuth2TokenExtractor(AsciiString header) {
        this.header = header;
    }

    @Override
    @Nullable
    public OAuth2Token apply(HttpHeaders headers) {
        String authorization = (String)headers.get(this.header);
        if (Strings.isNullOrEmpty(authorization)) {
            return null;
        }
        Matcher matcher = AUTHORIZATION_HEADER_PATTERN.matcher(authorization);
        if (!matcher.matches()) {
            logger.warn("Invalid authorization header: " + authorization);
            return null;
        }
        return OAuth2Token.of(matcher.group("accessToken"));
    }
}

