/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.composition;

import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.PathMapped;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.Router;
import com.linecorp.armeria.server.Routers;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceCallbackInvoker;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.ServiceRequestContextWrapper;
import com.linecorp.armeria.server.composition.CompositeServiceEntry;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class AbstractCompositeService<I extends Request, O extends Response>
implements Service<I, O> {
    private final List<CompositeServiceEntry<I, O>> services;
    @Nullable
    private Server server;
    @Nullable
    private Router<Service<I, O>> router;

    @SafeVarargs
    protected AbstractCompositeService(CompositeServiceEntry<I, O> ... services) {
        this(Arrays.asList(Objects.requireNonNull(services, "services")));
    }

    protected AbstractCompositeService(Iterable<CompositeServiceEntry<I, O>> services) {
        Objects.requireNonNull(services, "services");
        this.services = ImmutableList.copyOf(services);
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        Preconditions.checkState(this.server == null, "cannot be added to more than one server");
        this.server = cfg.server();
        this.router = Routers.ofCompositeService(this.services);
        MeterRegistry registry = this.server.meterRegistry();
        MeterIdPrefix meterIdPrefix = new MeterIdPrefix("armeria.server.router.compositeServiceCache", "hostnamePattern", cfg.virtualHost().hostnamePattern(), "pathMapping", cfg.pathMapping().meterTag());
        this.router.registerMetrics(registry, meterIdPrefix);
        for (CompositeServiceEntry<I, O> e : this.services()) {
            ServiceCallbackInvoker.invokeServiceAdded(cfg, e.service());
        }
    }

    protected List<CompositeServiceEntry<I, O>> services() {
        return this.services;
    }

    protected <T extends Service<I, O>> T serviceAt(int index) {
        return (T)this.services().get(index).service();
    }

    protected PathMapped<Service<I, O>> findService(PathMappingContext mappingCtx) {
        assert (this.router != null);
        return this.router.find(mappingCtx);
    }

    @Override
    public O serve(ServiceRequestContext ctx, I req) throws Exception {
        PathMappingContext mappingCtx = ctx.pathMappingContext();
        PathMapped<Service<I, O>> mapped = this.findService(mappingCtx.overridePath(ctx.mappedPath()));
        if (!mapped.isPresent()) {
            throw HttpStatusException.of(HttpStatus.NOT_FOUND);
        }
        Optional<String> childPrefix = mapped.mapping().prefix();
        if (childPrefix.isPresent()) {
            PathMapping newMapping = PathMapping.ofPrefix(ctx.pathMapping().prefix().get() + childPrefix.get().substring(1));
            CompositeServiceRequestContext newCtx = new CompositeServiceRequestContext(ctx, newMapping, mapped.mappingResult().path());
            try (SafeCloseable ignored = newCtx.push(false);){
                O o = mapped.value().serve(newCtx, req);
                return o;
            }
        }
        return mapped.value().serve(ctx, req);
    }

    private static final class CompositeServiceRequestContext
    extends ServiceRequestContextWrapper {
        private final PathMapping pathMapping;
        private final String mappedPath;
        @Nullable
        private String decodedMappedPath;

        CompositeServiceRequestContext(ServiceRequestContext delegate, PathMapping pathMapping, String mappedPath) {
            super(delegate);
            this.pathMapping = pathMapping;
            this.mappedPath = mappedPath;
        }

        @Override
        public ServiceRequestContext newDerivedContext() {
            return this.newDerivedContext(super.newDerivedContext());
        }

        @Override
        public ServiceRequestContext newDerivedContext(Request request) {
            return this.newDerivedContext(super.newDerivedContext(request));
        }

        private ServiceRequestContext newDerivedContext(ServiceRequestContext derivedCtx) {
            return new CompositeServiceRequestContext(derivedCtx, this.pathMapping, this.mappedPath);
        }

        @Override
        public PathMapping pathMapping() {
            return this.pathMapping;
        }

        @Override
        public String mappedPath() {
            return this.mappedPath;
        }

        @Override
        public String decodedMappedPath() {
            String decodedMappedPath = this.decodedMappedPath;
            if (decodedMappedPath != null) {
                return decodedMappedPath;
            }
            this.decodedMappedPath = ArmeriaHttpUtil.decodePath(this.mappedPath);
            return this.decodedMappedPath;
        }
    }
}

