/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.composition;

import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.composition.CompositeServiceEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractCompositeServiceBuilder<T extends AbstractCompositeServiceBuilder<T, I, O>, I extends Request, O extends Response> {
    private final List<CompositeServiceEntry<I, O>> services = new ArrayList<CompositeServiceEntry<I, O>>();
    private final List<CompositeServiceEntry<I, O>> unmodifiableServices = Collections.unmodifiableList(this.services);

    protected AbstractCompositeServiceBuilder() {
    }

    protected final T self() {
        return (T)this;
    }

    protected final List<CompositeServiceEntry<I, O>> services() {
        return this.unmodifiableServices;
    }

    @Deprecated
    protected T serviceAt(String pathPattern, Service<I, O> service) {
        return this.service(pathPattern, service);
    }

    protected T serviceUnder(String pathPrefix, Service<I, O> service) {
        return this.service(CompositeServiceEntry.ofPrefix(pathPrefix, service));
    }

    protected T service(String pathPattern, Service<I, O> service) {
        return this.service(CompositeServiceEntry.of(pathPattern, service));
    }

    protected T service(PathMapping pathMapping, Service<I, O> service) {
        return this.service(CompositeServiceEntry.of(pathMapping, service));
    }

    protected T service(CompositeServiceEntry<I, O> entry) {
        Objects.requireNonNull(entry, "entry");
        this.services.add(entry);
        return this.self();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.services() + ')';
    }
}

