/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.composition;

import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.Service;
import java.util.Objects;
import java.util.regex.Pattern;

public final class CompositeServiceEntry<I extends Request, O extends Response> {
    private final PathMapping pathMapping;
    private final Service<I, O> service;

    public static <I extends Request, O extends Response> CompositeServiceEntry<I, O> ofRegex(Pattern regex, Service<I, O> service) {
        return new CompositeServiceEntry<I, O>(PathMapping.ofRegex(regex), service);
    }

    public static <I extends Request, O extends Response> CompositeServiceEntry<I, O> ofGlob(String glob, Service<I, O> service) {
        return new CompositeServiceEntry<I, O>(PathMapping.ofGlob(glob), service);
    }

    public static <I extends Request, O extends Response> CompositeServiceEntry<I, O> ofPrefix(String pathPrefix, Service<I, O> service) {
        return new CompositeServiceEntry<I, O>(PathMapping.ofPrefix(pathPrefix), service);
    }

    public static <I extends Request, O extends Response> CompositeServiceEntry<I, O> ofExact(String exactPath, Service<I, O> service) {
        return new CompositeServiceEntry<I, O>(PathMapping.ofExact(exactPath), service);
    }

    public static <I extends Request, O extends Response> CompositeServiceEntry<I, O> ofCatchAll(Service<I, O> service) {
        return new CompositeServiceEntry<I, O>(PathMapping.ofCatchAll(), service);
    }

    public static <I extends Request, O extends Response> CompositeServiceEntry<I, O> of(String pathPattern, Service<I, O> service) {
        return new CompositeServiceEntry<I, O>(PathMapping.of(pathPattern), service);
    }

    public static <I extends Request, O extends Response> CompositeServiceEntry<I, O> of(PathMapping pathMapping, Service<I, O> service) {
        return new CompositeServiceEntry<I, O>(pathMapping, service);
    }

    private CompositeServiceEntry(PathMapping pathMapping, Service<I, O> service) {
        this.pathMapping = Objects.requireNonNull(pathMapping, "pathMapping");
        this.service = Objects.requireNonNull(service, "service");
    }

    public PathMapping pathMapping() {
        return this.pathMapping;
    }

    public Service<I, O> service() {
        return this.service;
    }

    public String toString() {
        return this.pathMapping + " -> " + this.service;
    }
}

