/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.cors;

import com.linecorp.armeria.common.DefaultHttpHeaders;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.cors.CorsServiceBuilder;
import io.netty.util.AsciiString;
import java.time.Instant;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class CorsConfig {
    public static final CorsConfig DISABLED = new CorsConfig();
    private final boolean enabled;
    @Nullable
    private final Set<String> origins;
    private final boolean anyOriginSupported;
    private final boolean nullOriginAllowed;
    private final boolean credentialsAllowed;
    private final boolean shortCircuit;
    private final long maxAge;
    @Nullable
    private final Set<AsciiString> exposedHeaders;
    @Nullable
    private final Set<HttpMethod> allowedRequestMethods;
    @Nullable
    private final Set<AsciiString> allowedRequestHeaders;
    @Nullable
    private final Map<AsciiString, Supplier<?>> preflightResponseHeaders;

    CorsConfig() {
        this.enabled = false;
        this.origins = null;
        this.anyOriginSupported = false;
        this.nullOriginAllowed = false;
        this.credentialsAllowed = false;
        this.shortCircuit = false;
        this.maxAge = 0L;
        this.exposedHeaders = null;
        this.allowedRequestMethods = null;
        this.allowedRequestHeaders = null;
        this.preflightResponseHeaders = null;
    }

    CorsConfig(CorsServiceBuilder builder) {
        this.enabled = true;
        this.origins = builder.origins;
        this.anyOriginSupported = builder.anyOriginSupported;
        this.nullOriginAllowed = builder.nullOriginAllowed;
        this.credentialsAllowed = builder.credentialsAllowed;
        this.shortCircuit = builder.shortCircuit;
        this.maxAge = builder.maxAge;
        this.exposedHeaders = builder.exposedHeaders.isEmpty() ? Collections.emptySet() : ImmutableSet.copyOf(builder.exposedHeaders);
        this.allowedRequestMethods = EnumSet.copyOf(builder.allowedRequestMethods);
        Set<Object> set = this.allowedRequestHeaders = builder.allowedRequestHeaders.isEmpty() ? Collections.emptySet() : ImmutableSet.copyOf(builder.allowedRequestHeaders);
        Map<Object, Object> preflightResponseHeaders = builder.preflightResponseHeadersDisabled ? Collections.emptyMap() : (builder.preflightResponseHeaders.isEmpty() ? ImmutableMap.of(HttpHeaderNames.DATE, InstantValueSupplier.INSTANCE, HttpHeaderNames.CONTENT_LENGTH, ConstantValueSupplier.ZERO) : ImmutableMap.copyOf(builder.preflightResponseHeaders));
        this.preflightResponseHeaders = preflightResponseHeaders;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String origin() {
        this.ensureEnabled();
        return this.origins.isEmpty() ? "*" : this.origins.iterator().next();
    }

    public Set<String> origins() {
        this.ensureEnabled();
        return this.origins;
    }

    public boolean isAnyOriginSupported() {
        this.ensureEnabled();
        return this.anyOriginSupported;
    }

    public boolean isNullOriginAllowed() {
        this.ensureEnabled();
        return this.nullOriginAllowed;
    }

    public boolean isCredentialsAllowed() {
        this.ensureEnabled();
        return this.credentialsAllowed;
    }

    public boolean isShortCircuit() {
        this.ensureEnabled();
        return this.shortCircuit;
    }

    public long maxAge() {
        this.ensureEnabled();
        return this.maxAge;
    }

    public Set<AsciiString> exposedHeaders() {
        this.ensureEnabled();
        return this.exposedHeaders;
    }

    public Set<HttpMethod> allowedRequestMethods() {
        this.ensureEnabled();
        return this.allowedRequestMethods;
    }

    public Set<AsciiString> allowedRequestHeaders() {
        this.ensureEnabled();
        return this.allowedRequestHeaders;
    }

    public HttpHeaders preflightResponseHeaders() {
        this.ensureEnabled();
        if (this.preflightResponseHeaders.isEmpty()) {
            return HttpHeaders.EMPTY_HEADERS;
        }
        DefaultHttpHeaders preflightHeaders = new DefaultHttpHeaders(false);
        for (Map.Entry<AsciiString, Supplier<?>> entry : this.preflightResponseHeaders.entrySet()) {
            Object value = CorsConfig.getValue(entry.getValue());
            if (value instanceof Iterable) {
                preflightHeaders.addObject(entry.getKey(), (Iterable)value);
                continue;
            }
            preflightHeaders.addObject(entry.getKey(), value);
        }
        return preflightHeaders;
    }

    private void ensureEnabled() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("CORS support not enabled");
        }
    }

    private static <T> T getValue(Supplier<T> callable) {
        try {
            return callable.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("could not generate value for supplier: " + callable, e);
        }
    }

    public String toString() {
        return CorsConfig.toString(this, this.enabled, this.origins, this.anyOriginSupported, this.nullOriginAllowed, this.credentialsAllowed, this.shortCircuit, this.maxAge, this.exposedHeaders, this.allowedRequestMethods, this.allowedRequestHeaders, this.preflightResponseHeaders);
    }

    static String toString(Object obj, boolean enabled, @Nullable Set<String> origins, boolean anyOriginSupported, boolean nullOriginAllowed, boolean credentialsAllowed, boolean shortCircuit, long maxAge, @Nullable Set<AsciiString> exposedHeaders, @Nullable Set<HttpMethod> allowedRequestMethods, @Nullable Set<AsciiString> allowedRequestHeaders, @Nullable Map<AsciiString, Supplier<?>> preflightResponseHeaders) {
        if (enabled) {
            return MoreObjects.toStringHelper(obj).add("origins", origins).add("anyOriginSupported", anyOriginSupported).add("nullOriginAllowed", nullOriginAllowed).add("credentialsAllowed", credentialsAllowed).add("shortCircuit", shortCircuit).add("maxAge", maxAge).add("exposedHeaders", exposedHeaders).add("allowedRequestMethods", allowedRequestMethods).add("allowedRequestHeaders", allowedRequestHeaders).add("preflightResponseHeaders", preflightResponseHeaders).toString();
        }
        return obj.getClass().getSimpleName() + "{disabled}";
    }

    static final class InstantValueSupplier
    implements Supplier<Instant> {
        static final InstantValueSupplier INSTANCE = new InstantValueSupplier();

        InstantValueSupplier() {
        }

        @Override
        public Instant get() {
            return Instant.now();
        }

        public String toString() {
            return "<now>";
        }
    }

    static final class ConstantValueSupplier
    implements Supplier<Object> {
        static final ConstantValueSupplier ZERO = new ConstantValueSupplier("0");
        private final Object value;

        ConstantValueSupplier(Object value) {
            this.value = value;
        }

        @Override
        public Object get() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

