/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.cors;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.cors.CorsConfig;
import com.linecorp.armeria.server.cors.CorsService;
import io.netty.util.AsciiString;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public final class CorsServiceBuilder {
    final Set<String> origins;
    final boolean anyOriginSupported;
    boolean nullOriginAllowed;
    boolean credentialsAllowed;
    boolean shortCircuit;
    long maxAge;
    final Set<AsciiString> exposedHeaders = new HashSet<AsciiString>();
    final Set<HttpMethod> allowedRequestMethods = new HashSet<HttpMethod>();
    final Set<AsciiString> allowedRequestHeaders = new HashSet<AsciiString>();
    final Map<AsciiString, Supplier<?>> preflightResponseHeaders = new HashMap();
    boolean preflightResponseHeadersDisabled;

    public static CorsServiceBuilder forAnyOrigin() {
        return new CorsServiceBuilder();
    }

    public static CorsServiceBuilder forOrigin(String origin) {
        Objects.requireNonNull(origin, "origin");
        if ("*".equals(origin)) {
            return new CorsServiceBuilder();
        }
        return new CorsServiceBuilder(origin);
    }

    public static CorsServiceBuilder forOrigins(String ... origins) {
        Objects.requireNonNull(origins, "origins");
        for (int i = 0; i < origins.length; ++i) {
            if (origins[i] != null) continue;
            throw new NullPointerException("origins[" + i + ']');
        }
        return new CorsServiceBuilder(origins);
    }

    CorsServiceBuilder(String ... origins) {
        LinkedHashSet<String> originsCopy = new LinkedHashSet<String>();
        for (String o : origins) {
            originsCopy.add(Ascii.toLowerCase(o));
        }
        this.origins = Collections.unmodifiableSet(originsCopy);
        this.anyOriginSupported = false;
    }

    CorsServiceBuilder() {
        this.anyOriginSupported = true;
        this.origins = Collections.emptySet();
    }

    public CorsServiceBuilder allowNullOrigin() {
        this.nullOriginAllowed = true;
        return this;
    }

    public CorsServiceBuilder allowCredentials() {
        this.credentialsAllowed = true;
        return this;
    }

    public CorsServiceBuilder shortCircuit() {
        this.shortCircuit = true;
        return this;
    }

    public CorsServiceBuilder maxAge(long maxAge) {
        if (maxAge <= 0L) {
            throw new IllegalArgumentException("maxAge: " + maxAge + " (expected: > 0)");
        }
        this.maxAge = maxAge;
        return this;
    }

    public CorsServiceBuilder exposeHeaders(String ... headers) {
        Objects.requireNonNull(headers, "headers");
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i] != null) continue;
            throw new NullPointerException("headers[" + i + ']');
        }
        Arrays.stream(headers).map(HttpHeaderNames::of).forEach(this.exposedHeaders::add);
        return this;
    }

    public CorsServiceBuilder exposeHeaders(AsciiString ... headers) {
        Objects.requireNonNull(headers, "headers");
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i] != null) continue;
            throw new NullPointerException("headers[" + i + ']');
        }
        Collections.addAll(this.exposedHeaders, headers);
        return this;
    }

    public CorsServiceBuilder allowRequestMethods(HttpMethod ... methods) {
        Objects.requireNonNull(methods, "methods");
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i] != null) continue;
            throw new NullPointerException("methods[" + i + ']');
        }
        Collections.addAll(this.allowedRequestMethods, methods);
        return this;
    }

    public CorsServiceBuilder allowRequestHeaders(String ... headers) {
        Objects.requireNonNull(headers, "headers");
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i] != null) continue;
            throw new NullPointerException("headers[" + i + ']');
        }
        Arrays.stream(headers).map(HttpHeaderNames::of).forEach(this.allowedRequestHeaders::add);
        return this;
    }

    public CorsServiceBuilder allowRequestHeaders(AsciiString ... headers) {
        Objects.requireNonNull(headers, "headers");
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i] != null) continue;
            throw new NullPointerException("headers[" + i + ']');
        }
        this.allowedRequestHeaders.addAll(Arrays.asList(headers));
        return this;
    }

    public CorsServiceBuilder preflightResponseHeader(String name, Object ... values) {
        Objects.requireNonNull(name, "name");
        return this.preflightResponseHeader(HttpHeaderNames.of(name), values);
    }

    public CorsServiceBuilder preflightResponseHeader(AsciiString name, Object ... values) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(values, "values");
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new NullPointerException("values[" + i + ']');
        }
        if (values.length == 1) {
            this.preflightResponseHeaders.put(name, new CorsConfig.ConstantValueSupplier(values[0]));
        } else {
            this.preflightResponseHeader(name, Arrays.asList(values));
        }
        return this;
    }

    public <T> CorsServiceBuilder preflightResponseHeader(AsciiString name, Iterable<T> values) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(values, "values");
        this.preflightResponseHeaders.put(name, new CorsConfig.ConstantValueSupplier(values));
        return this;
    }

    public <T> CorsServiceBuilder preflightResponseHeader(AsciiString name, Supplier<T> valueSupplier) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(valueSupplier, "valueSupplier");
        this.preflightResponseHeaders.put(name, valueSupplier);
        return this;
    }

    public CorsServiceBuilder disablePreflightResponseHeaders() {
        this.preflightResponseHeadersDisabled = true;
        return this;
    }

    public CorsService build(Service<HttpRequest, HttpResponse> delegate) {
        return new CorsService(delegate, new CorsConfig(this));
    }

    public Function<Service<HttpRequest, HttpResponse>, CorsService> newDecorator() {
        CorsConfig config = new CorsConfig(this);
        return s -> new CorsService((Service<HttpRequest, HttpResponse>)s, config);
    }

    public String toString() {
        return CorsConfig.toString(this, true, this.origins, this.anyOriginSupported, this.nullOriginAllowed, this.credentialsAllowed, this.shortCircuit, this.maxAge, this.exposedHeaders, this.allowedRequestMethods, this.allowedRequestHeaders, this.preflightResponseHeaders);
    }
}

