/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.ListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.composition.AbstractCompositeService;
import com.linecorp.armeria.server.composition.CompositeServiceEntry;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import com.linecorp.armeria.server.docs.ExceptionInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.docs.StructInfo;
import com.linecorp.armeria.server.file.AbstractHttpVfs;
import com.linecorp.armeria.server.file.HttpFileService;
import com.linecorp.armeria.server.file.HttpVfs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DocService
extends AbstractCompositeService<HttpRequest, HttpResponse> {
    private static final ObjectMapper mapper = new ObjectMapper();
    static final List<DocServicePlugin> plugins = Streams.stream(ServiceLoader.load(DocServicePlugin.class, DocService.class.getClassLoader())).collect(ImmutableList.toImmutableList());
    private final Map<String, ListMultimap<String, HttpHeaders>> exampleHttpHeaders;
    private final Map<String, ListMultimap<String, String>> exampleRequests;
    @Nullable
    private Server server;

    public DocService() {
        this(ImmutableMap.of(), ImmutableMap.of(), ImmutableList.of());
    }

    DocService(Map<String, ListMultimap<String, HttpHeaders>> exampleHttpHeaders, Map<String, ListMultimap<String, String>> exampleRequests, List<BiFunction<ServiceRequestContext, HttpRequest, String>> injectedScriptSuppliers) {
        super(CompositeServiceEntry.ofExact("/specification.json", HttpFileService.forVfs(new DocServiceVfs())), CompositeServiceEntry.ofExact("/injected.js", (ctx, req) -> HttpResponse.of(MediaType.JAVASCRIPT_UTF_8, injectedScriptSuppliers.stream().map(f -> (String)f.apply(ctx, req)).collect(Collectors.joining("\n")))), CompositeServiceEntry.ofCatchAll(HttpFileService.forClassPath(DocService.class.getClassLoader(), "com/linecorp/armeria/server/docs")));
        this.exampleHttpHeaders = DocService.immutableCopyOf(exampleHttpHeaders, "exampleHttpHeaders");
        this.exampleRequests = DocService.immutableCopyOf(exampleRequests, "exampleRequests");
    }

    private static <T> Map<String, ListMultimap<String, T>> immutableCopyOf(Map<String, ListMultimap<String, T>> map, String name) {
        Objects.requireNonNull(map, name);
        return map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ImmutableListMultimap.copyOf((Multimap)e.getValue())));
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        super.serviceAdded(cfg);
        if (this.server != null) {
            if (this.server != cfg.server()) {
                throw new IllegalStateException("cannot be added to more than one server");
            }
            return;
        }
        this.server = cfg.server();
        this.server.addListener(new ServerListenerAdapter(){

            @Override
            public void serverStarting(Server server) throws Exception {
                ServerConfig config = server.config();
                List<VirtualHost> virtualHosts = config.findVirtualHosts(DocService.this);
                List services = config.serviceConfigs().stream().filter(se -> virtualHosts.contains(se.virtualHost())).collect(ImmutableList.toImmutableList());
                ServiceSpecification spec = DocService.generate(services);
                spec = DocService.addDocStrings(spec, services);
                spec = DocService.this.addExamples(spec);
                DocService.this.vfs().setSpecification(mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)spec));
            }
        });
    }

    private static ServiceSpecification generate(List<ServiceConfig> services) {
        return ServiceSpecification.merge(plugins.stream().map(plugin -> plugin.generateSpecification(DocService.findSupportedServices(plugin, services))).collect(ImmutableList.toImmutableList()));
    }

    private static ServiceSpecification addDocStrings(ServiceSpecification spec, List<ServiceConfig> services) {
        Map docStrings = plugins.stream().flatMap(plugin -> plugin.loadDocStrings(DocService.findSupportedServices(plugin, services)).entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
        return new ServiceSpecification(spec.services().stream().map(service -> DocService.addServiceDocStrings(service, docStrings)).collect(ImmutableList.toImmutableList()), spec.enums().stream().map(e -> DocService.addEnumDocStrings(e, docStrings)).collect(ImmutableList.toImmutableList()), spec.structs().stream().map(s -> DocService.addStructDocStrings(s, docStrings)).collect(ImmutableList.toImmutableList()), spec.exceptions().stream().map(e -> DocService.addExceptionDocStrings(e, docStrings)).collect(ImmutableList.toImmutableList()), spec.exampleHttpHeaders());
    }

    private static ServiceInfo addServiceDocStrings(ServiceInfo service, Map<String, String> docStrings) {
        return new ServiceInfo(service.name(), service.methods().stream().map(method -> DocService.addMethodDocStrings(service, method, docStrings)).collect(ImmutableList.toImmutableList()), service.exampleHttpHeaders(), DocService.docString(service.name(), service.docString(), docStrings));
    }

    private static MethodInfo addMethodDocStrings(ServiceInfo service, MethodInfo method, Map<String, String> docStrings) {
        return new MethodInfo(method.name(), method.returnTypeSignature(), method.parameters().stream().map(field -> DocService.addParameterDocString(service, method, field, docStrings)).collect(ImmutableList.toImmutableList()), method.exceptionTypeSignatures(), method.endpoints(), method.exampleHttpHeaders(), method.exampleRequests(), DocService.docString(service.name() + '/' + method.name(), method.docString(), docStrings));
    }

    private static FieldInfo addParameterDocString(ServiceInfo service, MethodInfo method, FieldInfo field, Map<String, String> docStrings) {
        return new FieldInfo(field.name(), field.requirement(), field.typeSignature(), DocService.docString(service.name() + '/' + method.name() + '/' + field.name(), field.docString(), docStrings));
    }

    private static EnumInfo addEnumDocStrings(EnumInfo e, Map<String, String> docStrings) {
        return new EnumInfo(e.name(), e.values().stream().map(v -> DocService.addEnumValueDocString(e, v, docStrings)).collect(ImmutableList.toImmutableList()), DocService.docString(e.name(), e.docString(), docStrings));
    }

    private static EnumValueInfo addEnumValueDocString(EnumInfo e, EnumValueInfo v, Map<String, String> docStrings) {
        return new EnumValueInfo(v.name(), DocService.docString(e.name() + '/' + v.name(), v.docString(), docStrings));
    }

    private static StructInfo addStructDocStrings(StructInfo struct, Map<String, String> docStrings) {
        return new StructInfo(struct.name(), struct.fields().stream().map(field -> DocService.addFieldDocString(struct, field, docStrings)).collect(ImmutableList.toImmutableList()), DocService.docString(struct.name(), struct.docString(), docStrings));
    }

    private static ExceptionInfo addExceptionDocStrings(ExceptionInfo e, Map<String, String> docStrings) {
        return new ExceptionInfo(e.name(), e.fields().stream().map(field -> DocService.addFieldDocString(e, field, docStrings)).collect(ImmutableList.toImmutableList()), DocService.docString(e.name(), e.docString(), docStrings));
    }

    private static FieldInfo addFieldDocString(NamedTypeInfo parent, FieldInfo field, Map<String, String> docStrings) {
        return new FieldInfo(field.name(), field.requirement(), field.typeSignature(), DocService.docString(parent.name() + '/' + field.name(), field.docString(), docStrings));
    }

    private static String docString(String key, @Nullable String currentDocString, Map<String, String> docStrings) {
        return currentDocString != null ? currentDocString : docStrings.get(key);
    }

    private ServiceSpecification addExamples(ServiceSpecification spec) {
        return new ServiceSpecification(spec.services().stream().map(this::addServiceExamples).collect(ImmutableList.toImmutableList()), spec.enums(), spec.structs(), spec.exceptions(), Iterables.concat(spec.exampleHttpHeaders(), ((ListMultimap)this.exampleHttpHeaders.getOrDefault("", ImmutableListMultimap.of())).get("")));
    }

    private ServiceInfo addServiceExamples(ServiceInfo service) {
        ListMultimap exampleHttpHeaders = this.exampleHttpHeaders.getOrDefault(service.name(), ImmutableListMultimap.of());
        ListMultimap exampleRequests = this.exampleRequests.getOrDefault(service.name(), ImmutableListMultimap.of());
        return new ServiceInfo(service.name(), service.methods().stream().map(m -> new MethodInfo(m.name(), m.returnTypeSignature(), m.parameters(), m.exceptionTypeSignatures(), m.endpoints(), Iterables.concat(m.exampleHttpHeaders(), exampleHttpHeaders.get(m.name())), Iterables.concat(m.exampleRequests(), exampleRequests.get(m.name())), m.docString()))::iterator, Iterables.concat(service.exampleHttpHeaders(), exampleHttpHeaders.get("")), service.docString());
    }

    DocServiceVfs vfs() {
        return (DocServiceVfs)((HttpFileService)this.serviceAt(0)).config().vfs();
    }

    private static Set<ServiceConfig> findSupportedServices(DocServicePlugin plugin, List<ServiceConfig> services) {
        Set<Class<? extends Service<?, ?>>> supportedServiceTypes = plugin.supportedServiceTypes();
        return services.stream().filter(serviceCfg -> DocService.isSupported(serviceCfg, supportedServiceTypes)).collect(ImmutableSet.toImmutableSet());
    }

    private static boolean isSupported(ServiceConfig serviceCfg, Set<Class<? extends Service<?, ?>>> supportedServiceTypes) {
        return supportedServiceTypes.stream().anyMatch(type -> serviceCfg.service().as(type).isPresent());
    }

    static final class DocServiceVfs
    extends AbstractHttpVfs {
        private volatile HttpVfs.Entry entry = HttpVfs.Entry.NONE;

        DocServiceVfs() {
        }

        @Override
        public HttpVfs.Entry get(String path, @Nullable String contentEncoding) {
            return this.entry;
        }

        @Override
        public String meterTag() {
            return DocService.class.getSimpleName();
        }

        void setSpecification(byte[] content) {
            assert (this.entry == HttpVfs.Entry.NONE);
            this.entry = new HttpVfs.ByteArrayEntry("/", MediaType.JSON_UTF_8, content);
        }
    }
}

