/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ArrayListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ListMultimap;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public final class DocServiceBuilder {
    private final Map<String, ListMultimap<String, HttpHeaders>> exampleHttpHeaders = new HashMap<String, ListMultimap<String, HttpHeaders>>();
    private final Map<String, ListMultimap<String, String>> exampleRequests = new HashMap<String, ListMultimap<String, String>>();
    private final List<BiFunction<ServiceRequestContext, HttpRequest, String>> injectedScriptSuppliers = new ArrayList<BiFunction<ServiceRequestContext, HttpRequest, String>>();

    public DocServiceBuilder exampleHttpHeaders(HttpHeaders ... exampleHttpHeaders) {
        Objects.requireNonNull(exampleHttpHeaders, "exampleHttpHeaders");
        return this.exampleHttpHeaders(ImmutableList.copyOf(exampleHttpHeaders));
    }

    public DocServiceBuilder exampleHttpHeaders(Iterable<? extends HttpHeaders> exampleHttpHeaders) {
        return this.exampleHttpHeaders0("", "", exampleHttpHeaders);
    }

    public DocServiceBuilder exampleHttpHeaders(Class<?> serviceType, HttpHeaders ... exampleHttpHeaders) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleHttpHeaders(serviceType.getName(), exampleHttpHeaders);
    }

    public DocServiceBuilder exampleHttpHeaders(Class<?> serviceType, Iterable<? extends HttpHeaders> exampleHttpHeaders) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleHttpHeaders(serviceType.getName(), exampleHttpHeaders);
    }

    public DocServiceBuilder exampleHttpHeaders(String serviceName, HttpHeaders ... exampleHttpHeaders) {
        Objects.requireNonNull(exampleHttpHeaders, "exampleHttpHeaders");
        return this.exampleHttpHeaders(serviceName, ImmutableList.copyOf(exampleHttpHeaders));
    }

    public DocServiceBuilder exampleHttpHeaders(String serviceName, Iterable<? extends HttpHeaders> exampleHttpHeaders) {
        Objects.requireNonNull(serviceName, "serviceName");
        Preconditions.checkArgument(!serviceName.isEmpty(), "serviceName is empty.");
        Objects.requireNonNull(exampleHttpHeaders, "exampleHttpHeaders");
        return this.exampleHttpHeaders0(serviceName, "", exampleHttpHeaders);
    }

    public DocServiceBuilder exampleHttpHeaders(Class<?> serviceType, String methodName, HttpHeaders ... exampleHttpHeaders) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleHttpHeaders(serviceType.getName(), methodName, exampleHttpHeaders);
    }

    public DocServiceBuilder exampleHttpHeaders(Class<?> serviceType, String methodName, Iterable<? extends HttpHeaders> exampleHttpHeaders) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleHttpHeaders(serviceType.getName(), methodName, exampleHttpHeaders);
    }

    public DocServiceBuilder exampleHttpHeaders(String serviceName, String methodName, HttpHeaders ... exampleHttpHeaders) {
        Objects.requireNonNull(exampleHttpHeaders, "exampleHttpHeaders");
        return this.exampleHttpHeaders(serviceName, methodName, ImmutableList.copyOf(exampleHttpHeaders));
    }

    public DocServiceBuilder exampleHttpHeaders(String serviceName, String methodName, Iterable<? extends HttpHeaders> exampleHttpHeaders) {
        Objects.requireNonNull(serviceName, "serviceName");
        Preconditions.checkArgument(!serviceName.isEmpty(), "serviceName is empty.");
        Objects.requireNonNull(methodName, "methodName");
        Preconditions.checkArgument(!methodName.isEmpty(), "methodName is empty.");
        Objects.requireNonNull(exampleHttpHeaders, "exampleHttpHeaders");
        return this.exampleHttpHeaders0(serviceName, methodName, exampleHttpHeaders);
    }

    private DocServiceBuilder exampleHttpHeaders0(String serviceName, String methodName, Iterable<? extends HttpHeaders> exampleHttpHeaders) {
        for (HttpHeaders httpHeaders : exampleHttpHeaders) {
            Objects.requireNonNull(httpHeaders, "exampleHttpHeaders contains null.");
            this.exampleHttpHeaders.computeIfAbsent(serviceName, unused -> ArrayListMultimap.create()).put(methodName, HttpHeaders.copyOf(httpHeaders).asImmutable());
        }
        return this;
    }

    public DocServiceBuilder exampleRequestForMethod(Class<?> serviceType, String methodName, Object ... exampleRequests) {
        Objects.requireNonNull(exampleRequests, "exampleRequests");
        return this.exampleRequestForMethod(serviceType, methodName, ImmutableList.copyOf(exampleRequests));
    }

    public DocServiceBuilder exampleRequestForMethod(Class<?> serviceType, String methodName, Iterable<?> exampleRequests) {
        Objects.requireNonNull(serviceType, "serviceType");
        return this.exampleRequestForMethod(serviceType.getName(), methodName, exampleRequests);
    }

    public DocServiceBuilder exampleRequestForMethod(String serviceName, String methodName, Object ... exampleRequests) {
        Objects.requireNonNull(exampleRequests, "exampleRequests");
        return this.exampleRequestForMethod(serviceName, methodName, ImmutableList.copyOf(exampleRequests));
    }

    public DocServiceBuilder exampleRequestForMethod(String serviceName, String methodName, Iterable<?> exampleRequests) {
        Objects.requireNonNull(serviceName, "serviceName");
        Objects.requireNonNull(methodName, "methodName");
        Objects.requireNonNull(exampleRequests, "exampleRequests");
        for (Object e : exampleRequests) {
            Objects.requireNonNull(e, "exampleRequests contains null.");
            this.exampleRequest0(serviceName, methodName, DocServiceBuilder.serializeExampleRequest(serviceName, methodName, e));
        }
        return this;
    }

    public DocServiceBuilder exampleRequest(Object ... exampleRequests) {
        Objects.requireNonNull(exampleRequests, "exampleRequests");
        return this.exampleRequest(ImmutableList.copyOf(exampleRequests));
    }

    public DocServiceBuilder exampleRequest(Iterable<?> exampleRequests) {
        Objects.requireNonNull(exampleRequests, "exampleRequests");
        for (Object e : exampleRequests) {
            Objects.requireNonNull(e, "exampleRequests contains null.");
            String[] result = DocServiceBuilder.guessAndSerializeExampleRequest(e);
            this.exampleRequest0(result[0], result[1], result[2]);
        }
        return this;
    }

    public DocServiceBuilder injectedScript(String ... scripts) {
        Objects.requireNonNull(scripts, "scripts");
        return this.injectedScript(ImmutableList.copyOf(scripts));
    }

    public DocServiceBuilder injectedScript(Iterable<String> scripts) {
        Objects.requireNonNull(scripts, "scripts");
        for (String s : scripts) {
            Objects.requireNonNull(s, "scripts contains null.");
            this.injectedScriptSuppliers.add((unused1, unused2) -> s);
        }
        return this;
    }

    public DocServiceBuilder injectedScriptSupplier(BiFunction<ServiceRequestContext, HttpRequest, String> supplier) {
        this.injectedScriptSuppliers.add(Objects.requireNonNull(supplier, "supplier"));
        return this;
    }

    private void exampleRequest0(String serviceName, String methodName, String serializedExampleRequest) {
        this.exampleRequests.computeIfAbsent(serviceName, unused -> ArrayListMultimap.create()).put(methodName, serializedExampleRequest);
    }

    private static String serializeExampleRequest(String serviceName, String methodName, Object exampleRequest) {
        if (exampleRequest instanceof CharSequence) {
            return exampleRequest.toString();
        }
        for (DocServicePlugin generator : DocService.plugins) {
            Optional<String> result = generator.serializeExampleRequest(serviceName, methodName, exampleRequest);
            if (!result.isPresent()) continue;
            return result.get();
        }
        throw new IllegalArgumentException("could not find a plugin that can serialize: " + exampleRequest);
    }

    private static String[] guessAndSerializeExampleRequest(Object exampleRequest) {
        Preconditions.checkArgument(!(exampleRequest instanceof CharSequence), "can't guess service or method name from a string: ", exampleRequest);
        boolean guessed = false;
        for (DocServicePlugin plugin : DocService.plugins) {
            String f;
            if (plugin.supportedExampleRequestTypes().stream().noneMatch(type -> type.isInstance(exampleRequest))) continue;
            Optional<String> serviceName = plugin.guessServiceName(exampleRequest);
            Optional<String> methodName = plugin.guessServiceMethodName(exampleRequest);
            if (!serviceName.isPresent() || !methodName.isPresent()) continue;
            guessed = true;
            String s = serviceName.get();
            Optional<String> serialized = plugin.serializeExampleRequest(s, f = methodName.get(), exampleRequest);
            if (!serialized.isPresent()) continue;
            return new String[]{s, f, serialized.get()};
        }
        if (guessed) {
            throw new IllegalArgumentException("could not find a plugin that can serialize: " + exampleRequest);
        }
        throw new IllegalArgumentException("could not find a plugin that can guess the service and method name from: " + exampleRequest);
    }

    public DocService build() {
        return new DocService(this.exampleHttpHeaders, this.exampleRequests, this.injectedScriptSuppliers);
    }
}

