/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class EndpointInfo {
    private final String hostnamePattern;
    private final String path;
    @Nullable
    private final String fragment;
    private final MediaType defaultMimeType;
    private final Set<MediaType> availableMimeTypes;

    public EndpointInfo(String hostnamePattern, String path, @Nullable String fragment, SerializationFormat defaultFormat, Iterable<SerializationFormat> availableFormats) {
        this(hostnamePattern, path, fragment, defaultFormat.mediaType(), Streams.stream(availableFormats).map(SerializationFormat::mediaType)::iterator);
    }

    public EndpointInfo(String hostnamePattern, String path, @Nullable String fragment, MediaType defaultMimeType, Iterable<MediaType> availableMimeTypes) {
        this.hostnamePattern = Objects.requireNonNull(hostnamePattern, "hostnamePattern");
        this.path = Objects.requireNonNull(path, "path");
        this.fragment = Strings.emptyToNull(fragment);
        this.defaultMimeType = Objects.requireNonNull(defaultMimeType, "defaultFormat");
        this.availableMimeTypes = ImmutableSortedSet.copyOf(Comparator.comparing(MediaType::toString), Objects.requireNonNull(availableMimeTypes, "availableMimeTypes"));
    }

    @JsonProperty
    public String hostnamePattern() {
        return this.hostnamePattern;
    }

    @JsonProperty
    public String path() {
        return this.path;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String fragment() {
        return this.fragment;
    }

    @JsonProperty
    public MediaType defaultMimeType() {
        return this.defaultMimeType;
    }

    @JsonProperty
    public Set<MediaType> availableMimeTypes() {
        return this.availableMimeTypes;
    }

    public int hashCode() {
        return Objects.hash(this.hostnamePattern, this.path);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EndpointInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EndpointInfo that = (EndpointInfo)obj;
        return this.hostnamePattern.equals(that.hostnamePattern) && this.path.equals(that.path) && Objects.equals(this.fragment, that.fragment) && this.defaultMimeType.equals(that.defaultMimeType) && this.availableMimeTypes.equals(that.availableMimeTypes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("hostnamePattern", this.hostnamePattern).add("path", this.path).add("fragment", this.fragment).add("defaultMimeType", this.defaultMimeType).add("availableMimeTypes", this.availableMimeTypes).toString();
    }
}

