/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Objects;
import javax.annotation.Nullable;

public final class FieldInfo {
    private final String name;
    private final FieldRequirement requirement;
    private final TypeSignature typeSignature;
    @Nullable
    private final String docString;

    public FieldInfo(String name, FieldRequirement requirement, TypeSignature typeSignature) {
        this(name, requirement, typeSignature, null);
    }

    public FieldInfo(String name, FieldRequirement requirement, TypeSignature typeSignature, @Nullable String docString) {
        this.name = Objects.requireNonNull(name, "name");
        this.requirement = Objects.requireNonNull(requirement, "requirement");
        this.typeSignature = Objects.requireNonNull(typeSignature, "typeSignature");
        this.docString = Strings.emptyToNull(docString);
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public FieldRequirement requirement() {
        return this.requirement;
    }

    @JsonProperty
    public TypeSignature typeSignature() {
        return this.typeSignature;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String docString() {
        return this.docString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldInfo that = (FieldInfo)o;
        return this.name.equals(that.name) && this.requirement == that.requirement && this.typeSignature.equals(that.typeSignature);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.requirement, this.typeSignature});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("requirement", (Object)this.requirement).add("typeSignature", this.typeSignature).toString();
    }
}

