/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class MethodInfo {
    private final String name;
    private final TypeSignature returnTypeSignature;
    private final List<FieldInfo> parameters;
    private final Set<TypeSignature> exceptionTypeSignatures;
    private final Set<EndpointInfo> endpoints;
    private final List<HttpHeaders> exampleHttpHeaders;
    private final List<String> exampleRequests;
    @Nullable
    private final String docString;

    public MethodInfo(String name, TypeSignature returnTypeSignature, Iterable<FieldInfo> parameters, Iterable<TypeSignature> exceptionTypeSignatures, Iterable<EndpointInfo> endpoints) {
        this(name, returnTypeSignature, parameters, exceptionTypeSignatures, endpoints, ImmutableList.of(), ImmutableList.of(), null);
    }

    public MethodInfo(String name, TypeSignature returnTypeSignature, Iterable<FieldInfo> parameters, Iterable<TypeSignature> exceptionTypeSignatures, Iterable<EndpointInfo> endpoints, Iterable<HttpHeaders> exampleHttpHeaders, Iterable<String> exampleRequests, @Nullable String docString) {
        this.name = Objects.requireNonNull(name, "name");
        this.returnTypeSignature = Objects.requireNonNull(returnTypeSignature, "returnTypeSignature");
        this.parameters = ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters"));
        this.exceptionTypeSignatures = ImmutableSortedSet.copyOf(Comparator.comparing(TypeSignature::signature), Objects.requireNonNull(exceptionTypeSignatures, "exceptionTypeSignatures"));
        this.endpoints = ImmutableSortedSet.copyOf(Comparator.comparing(e -> e.hostnamePattern() + ':' + e.path()), Objects.requireNonNull(endpoints, "endpoints"));
        this.exampleHttpHeaders = Streams.stream(Objects.requireNonNull(exampleHttpHeaders, "exampleHttpHeaders")).map(HttpHeaders::copyOf).map(HttpHeaders::asImmutable).collect(ImmutableList.toImmutableList());
        this.exampleRequests = ImmutableList.copyOf(Objects.requireNonNull(exampleRequests, "exampleRequests"));
        this.docString = Strings.emptyToNull(docString);
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public TypeSignature returnTypeSignature() {
        return this.returnTypeSignature;
    }

    @JsonProperty
    public Set<EndpointInfo> endpoints() {
        return this.endpoints;
    }

    @JsonProperty
    public List<FieldInfo> parameters() {
        return this.parameters;
    }

    @JsonProperty
    public Set<TypeSignature> exceptionTypeSignatures() {
        return this.exceptionTypeSignatures;
    }

    @JsonProperty
    public List<HttpHeaders> exampleHttpHeaders() {
        return this.exampleHttpHeaders;
    }

    @JsonProperty
    public List<String> exampleRequests() {
        return this.exampleRequests;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String docString() {
        return this.docString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInfo that = (MethodInfo)o;
        return this.name.equals(that.name) && this.returnTypeSignature.equals(that.returnTypeSignature) && this.parameters.equals(that.parameters) && this.exceptionTypeSignatures.equals(that.exceptionTypeSignatures) && this.endpoints.equals(that.endpoints);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.returnTypeSignature, this.parameters, this.exceptionTypeSignatures, this.endpoints);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("returnTypeSignature", this.returnTypeSignature).add("parameters", this.parameters).add("exceptionTypeSignatures", this.exceptionTypeSignatures).add("endpoints", this.endpoints).toString();
    }
}

