/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class ServiceInfo {
    private final String name;
    private final Set<MethodInfo> methods;
    private final List<HttpHeaders> exampleHttpHeaders;
    @Nullable
    private final String docString;

    public ServiceInfo(String name, Iterable<MethodInfo> methods) {
        this(name, methods, ImmutableList.of(), null);
    }

    public ServiceInfo(String name, Iterable<MethodInfo> methods, Iterable<HttpHeaders> exampleHttpHeaders, @Nullable String docString) {
        this.name = Objects.requireNonNull(name, "name");
        Objects.requireNonNull(methods, "methods");
        this.methods = ImmutableSortedSet.copyOf(Comparator.comparing(MethodInfo::name), methods);
        this.exampleHttpHeaders = Streams.stream(Objects.requireNonNull(exampleHttpHeaders, "exampleHttpHeaders")).map(HttpHeaders::copyOf).map(HttpHeaders::asImmutable).collect(ImmutableList.toImmutableList());
        this.docString = Strings.emptyToNull(docString);
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public Set<MethodInfo> methods() {
        return this.methods;
    }

    public Set<TypeSignature> findNamedTypes() {
        HashSet collectedNamedTypes = new HashSet();
        this.methods().forEach(m -> {
            ServiceInfo.findNamedTypes(collectedNamedTypes, m.returnTypeSignature());
            m.parameters().forEach(p -> ServiceInfo.findNamedTypes(collectedNamedTypes, p.typeSignature()));
            m.exceptionTypeSignatures().forEach(s -> ServiceInfo.findNamedTypes(collectedNamedTypes, s));
        });
        return ImmutableSortedSet.copyOf(Comparator.comparing(TypeSignature::name), collectedNamedTypes);
    }

    static void findNamedTypes(Set<TypeSignature> collectedNamedTypes, TypeSignature typeSignature) {
        if (typeSignature.isNamed()) {
            collectedNamedTypes.add(typeSignature);
        }
        if (typeSignature.isContainer()) {
            typeSignature.typeParameters().forEach(p -> ServiceInfo.findNamedTypes(collectedNamedTypes, p));
        }
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String docString() {
        return this.docString;
    }

    @JsonProperty
    public List<HttpHeaders> exampleHttpHeaders() {
        return this.exampleHttpHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInfo that = (ServiceInfo)o;
        return this.name.equals(that.name) && this.methods.equals(that.methods);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.methods);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("methods", this.methods).add("exampleHttpHeaders", this.exampleHttpHeaders).add("docstring", this.docString).toString();
    }
}

