/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.ExceptionInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.StructInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class ServiceSpecification {
    private final Set<ServiceInfo> services;
    private final Set<EnumInfo> enums;
    private final Set<StructInfo> structs;
    private final Set<ExceptionInfo> exceptions;
    private final List<HttpHeaders> exampleHttpHeaders;

    public static ServiceSpecification merge(Iterable<ServiceSpecification> specs) {
        return new ServiceSpecification(Streams.stream(specs).flatMap(s -> s.services().stream())::iterator, Streams.stream(specs).flatMap(s -> s.enums().stream())::iterator, Streams.stream(specs).flatMap(s -> s.structs().stream())::iterator, Streams.stream(specs).flatMap(s -> s.exceptions().stream())::iterator);
    }

    public static ServiceSpecification generate(Iterable<ServiceInfo> services, Function<TypeSignature, ? extends NamedTypeInfo> namedTypeInfoFactory) {
        Set namedTypes = Streams.stream(services).flatMap(s -> s.findNamedTypes().stream()).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(TypeSignature::name)));
        HashMap<String, EnumInfo> enums = new HashMap<String, EnumInfo>();
        HashMap<String, StructInfo> structs = new HashMap<String, StructInfo>();
        HashMap<String, ExceptionInfo> exceptions = new HashMap<String, ExceptionInfo>();
        ServiceSpecification.generateNamedTypeInfos(namedTypeInfoFactory, enums, structs, exceptions, namedTypes);
        return new ServiceSpecification(services, enums.values(), structs.values(), exceptions.values());
    }

    private static void generateNamedTypeInfos(Function<TypeSignature, ? extends NamedTypeInfo> namedTypeInfoFactory, Map<String, EnumInfo> enums, Map<String, StructInfo> structs, Map<String, ExceptionInfo> exceptions, Set<TypeSignature> namedTypes) {
        namedTypes.forEach(type -> {
            String typeName = type.name();
            if (enums.containsKey(typeName) || structs.containsKey(typeName) || exceptions.containsKey(typeName)) {
                return;
            }
            NamedTypeInfo newInfo = (NamedTypeInfo)namedTypeInfoFactory.apply((TypeSignature)type);
            if (newInfo instanceof EnumInfo) {
                enums.put(newInfo.name(), (EnumInfo)newInfo);
            } else if (newInfo instanceof StructInfo) {
                structs.put(newInfo.name(), (StructInfo)newInfo);
            } else if (newInfo instanceof ExceptionInfo) {
                exceptions.put(newInfo.name(), (ExceptionInfo)newInfo);
            } else {
                throw new Error();
            }
            ServiceSpecification.generateNamedTypeInfos(namedTypeInfoFactory, enums, structs, exceptions, newInfo.findNamedTypes());
        });
    }

    public ServiceSpecification(Iterable<ServiceInfo> services, Iterable<EnumInfo> enums, Iterable<StructInfo> structs, Iterable<ExceptionInfo> exceptions) {
        this(services, enums, structs, exceptions, ImmutableList.of());
    }

    public ServiceSpecification(Iterable<ServiceInfo> services, Iterable<EnumInfo> enums, Iterable<StructInfo> structs, Iterable<ExceptionInfo> exceptions, Iterable<HttpHeaders> exampleHttpHeaders) {
        this.services = Streams.stream(Objects.requireNonNull(services, "services")).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(ServiceInfo::name)));
        this.enums = ServiceSpecification.collectNamedTypeInfo(enums, "enums");
        this.structs = ServiceSpecification.collectNamedTypeInfo(structs, "structs");
        this.exceptions = ServiceSpecification.collectNamedTypeInfo(exceptions, "exceptions");
        this.exampleHttpHeaders = Streams.stream(Objects.requireNonNull(exampleHttpHeaders, "exampleHttpHeaders")).map(headers -> HttpHeaders.copyOf(headers).asImmutable()).collect(ImmutableList.toImmutableList());
    }

    private static <T extends NamedTypeInfo> Set<T> collectNamedTypeInfo(Iterable<T> values, String name) {
        return Streams.stream(Objects.requireNonNull(values, name)).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(NamedTypeInfo::name)));
    }

    @JsonProperty
    public Set<ServiceInfo> services() {
        return this.services;
    }

    @JsonProperty
    public Set<EnumInfo> enums() {
        return this.enums;
    }

    @JsonProperty
    public Set<StructInfo> structs() {
        return this.structs;
    }

    @JsonProperty
    public Set<ExceptionInfo> exceptions() {
        return this.exceptions;
    }

    @JsonProperty
    public List<HttpHeaders> exampleHttpHeaders() {
        return this.exampleHttpHeaders;
    }
}

