/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.encoding;

import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.encoding.HttpEncoders;
import com.linecorp.armeria.server.encoding.HttpEncodingService;
import com.linecorp.armeria.server.encoding.HttpEncodingType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;

class HttpEncodedResponse
extends FilteredHttpResponse {
    private final HttpEncodingType encodingType;
    private final Predicate<MediaType> encodableContentTypePredicate;
    private final int minBytesToForceChunkedAndEncoding;
    @Nullable
    private ByteArrayOutputStream encodedStream;
    @Nullable
    private DeflaterOutputStream encodingStream;
    private boolean headersSent;

    HttpEncodedResponse(HttpResponse delegate, HttpEncodingType encodingType, Predicate<MediaType> encodableContentTypePredicate, int minBytesToForceChunkedAndEncoding) {
        super(delegate);
        this.encodingType = Objects.requireNonNull(encodingType, "encodingType");
        this.encodableContentTypePredicate = Objects.requireNonNull(encodableContentTypePredicate, "encodableContentTypePredicate");
        this.minBytesToForceChunkedAndEncoding = HttpEncodingService.validateMinBytesToForceChunkedAndEncoding(minBytesToForceChunkedAndEncoding);
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (obj instanceof HttpHeaders) {
            HttpHeaders headers = (HttpHeaders)obj;
            HttpStatus status = headers.status();
            if (status != null && status.codeClass() == HttpStatusClass.INFORMATIONAL) {
                return obj;
            }
            if (this.headersSent) {
                return obj;
            }
            if (status == null) {
                return obj;
            }
            this.headersSent = true;
            if (!this.shouldEncodeResponse(headers)) {
                return obj;
            }
            this.encodedStream = new ByteArrayOutputStream();
            this.encodingStream = HttpEncoders.getEncodingOutputStream(this.encodingType, this.encodedStream);
            headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            switch (this.encodingType) {
                case GZIP: {
                    headers.set(HttpHeaderNames.CONTENT_ENCODING, "gzip");
                    break;
                }
                case DEFLATE: {
                    headers.set(HttpHeaderNames.CONTENT_ENCODING, "deflate");
                }
            }
            headers.set(HttpHeaderNames.VARY, HttpHeaderNames.ACCEPT_ENCODING.toString());
            return headers;
        }
        if (this.encodingStream == null) {
            return obj;
        }
        HttpData data = (HttpData)obj;
        assert (this.encodedStream != null);
        try {
            this.encodingStream.write(data.array(), data.offset(), data.length());
            this.encodingStream.flush();
            HttpData status = HttpData.of(this.encodedStream.toByteArray());
            return status;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding HttpData, this should not happen with byte arrays.", e);
        }
        finally {
            this.encodedStream.reset();
        }
    }

    @Override
    protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
        this.closeEncoder();
        if (this.encodedStream != null && this.encodedStream.size() > 0) {
            subscriber.onNext((Object)HttpData.of(this.encodedStream.toByteArray()));
        }
    }

    @Override
    protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
        this.closeEncoder();
        return cause;
    }

    private void closeEncoder() {
        if (this.encodingStream == null) {
            return;
        }
        try {
            this.encodingStream.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error closing encodingStream, this should not happen with byte arrays.", e);
        }
    }

    private boolean shouldEncodeResponse(HttpHeaders headers) {
        if (headers.contains(HttpHeaderNames.CONTENT_ENCODING)) {
            return false;
        }
        if (headers.contentType() != null) {
            try {
                MediaType contentType = headers.contentType();
                if (!this.encodableContentTypePredicate.test(contentType)) {
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return !headers.contains(HttpHeaderNames.CONTENT_LENGTH) || headers.getInt(HttpHeaderNames.CONTENT_LENGTH) >= this.minBytesToForceChunkedAndEncoding;
    }
}

