/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.encoding;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.server.encoding.HttpEncodingType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;

final class HttpEncoders {
    @Nullable
    static HttpEncodingType getWrapperForRequest(HttpRequest request) {
        String acceptEncoding = (String)request.headers().get(HttpHeaderNames.ACCEPT_ENCODING);
        if (acceptEncoding == null) {
            return null;
        }
        return HttpEncoders.determineEncoding(acceptEncoding);
    }

    static DeflaterOutputStream getEncodingOutputStream(HttpEncodingType encodingType, OutputStream out) {
        switch (encodingType) {
            case GZIP: {
                try {
                    return new GZIPOutputStream(out, true);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error writing gzip header. This should not happen with byte arrays.", e);
                }
            }
            case DEFLATE: {
                return new DeflaterOutputStream(out, true);
            }
        }
        throw new IllegalArgumentException("Unexpected zlib type, this is a programming bug.");
    }

    @Nullable
    private static HttpEncodingType determineEncoding(String acceptEncoding) {
        float starQ = -1.0f;
        float gzipQ = -1.0f;
        float deflateQ = -1.0f;
        for (String encoding : acceptEncoding.split(",")) {
            float q = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q;
                continue;
            }
            if (encoding.contains("gzip") && q > gzipQ) {
                gzipQ = q;
                continue;
            }
            if (!encoding.contains("deflate") || !(q > deflateQ)) continue;
            deflateQ = q;
        }
        if (gzipQ > 0.0f || deflateQ > 0.0f) {
            if (gzipQ >= deflateQ) {
                return HttpEncodingType.GZIP;
            }
            return HttpEncodingType.DEFLATE;
        }
        if (starQ > 0.0f) {
            if (gzipQ == -1.0f) {
                return HttpEncodingType.GZIP;
            }
            if (deflateQ == -1.0f) {
                return HttpEncodingType.DEFLATE;
            }
        }
        return null;
    }

    private HttpEncoders() {
    }
}

