/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.encoding;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingService;
import com.linecorp.armeria.server.encoding.HttpEncodedResponse;
import com.linecorp.armeria.server.encoding.HttpEncoders;
import com.linecorp.armeria.server.encoding.HttpEncodingType;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class HttpEncodingService
extends SimpleDecoratingService<HttpRequest, HttpResponse> {
    private static final Predicate<MediaType> DEFAULT_ENCODABLE_CONTENT_TYPE_PREDICATE = contentType -> Stream.of(MediaType.ANY_TEXT_TYPE, MediaType.APPLICATION_XML_UTF_8, MediaType.JAVASCRIPT_UTF_8, MediaType.JSON_UTF_8).anyMatch(contentType::is);
    private static final int DEFAULT_MIN_BYTES_TO_FORCE_CHUNKED_AND_ENCODING = 1024;
    private final Predicate<MediaType> encodableContentTypePredicate;
    private final int minBytesToForceChunkedAndEncoding;

    public HttpEncodingService(Service<HttpRequest, HttpResponse> delegate) {
        this(delegate, DEFAULT_ENCODABLE_CONTENT_TYPE_PREDICATE, 1024);
    }

    public HttpEncodingService(Service<HttpRequest, HttpResponse> delegate, Predicate<MediaType> encodableContentTypePredicate, int minBytesToForceChunkedAndEncoding) {
        super(delegate);
        this.encodableContentTypePredicate = Objects.requireNonNull(encodableContentTypePredicate, "encodableContentTypePredicate");
        this.minBytesToForceChunkedAndEncoding = HttpEncodingService.validateMinBytesToForceChunkedAndEncoding(minBytesToForceChunkedAndEncoding);
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpEncodingType encodingType = HttpEncoders.getWrapperForRequest(req);
        HttpResponse delegateResponse = (HttpResponse)this.delegate().serve(ctx, (HttpRequest)req);
        if (encodingType == null) {
            return delegateResponse;
        }
        return new HttpEncodedResponse(delegateResponse, encodingType, this.encodableContentTypePredicate, this.minBytesToForceChunkedAndEncoding);
    }

    static int validateMinBytesToForceChunkedAndEncoding(int minBytesToForceChunkedAndEncoding) {
        if (minBytesToForceChunkedAndEncoding <= 0) {
            throw new IllegalArgumentException("minBytesToForceChunkedAndEncoding must be greater than 0.");
        }
        return minBytesToForceChunkedAndEncoding;
    }
}

