/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.server.file.AbstractHttpVfs;
import com.linecorp.armeria.server.file.FileSystemHttpVfs;
import com.linecorp.armeria.server.file.HttpVfs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.Nullable;

final class ClassPathHttpVfs
extends AbstractHttpVfs {
    private final ClassLoader classLoader;
    private final String rootDir;

    ClassPathHttpVfs(ClassLoader classLoader, String rootDir) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
        this.rootDir = ClassPathHttpVfs.normalizeRootDir(rootDir);
    }

    private static String normalizeRootDir(String rootDir) {
        Objects.requireNonNull(rootDir, "rootDir");
        if (rootDir.startsWith("/")) {
            rootDir = rootDir.substring(1);
        }
        if (rootDir.endsWith("/")) {
            rootDir = rootDir.substring(0, rootDir.length() - 1);
        }
        return rootDir;
    }

    @Override
    public HttpVfs.Entry get(String path, @Nullable String contentEncoding) {
        HttpVfs.AbstractEntry entry;
        String resourcePath = this.rootDir.isEmpty() ? path.substring(1) : this.rootDir + path;
        URL url = this.classLoader.getResource(resourcePath);
        if (url == null || url.getPath().endsWith("/")) {
            return HttpVfs.Entry.NONE;
        }
        if ("file".equals(url.getProtocol())) {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException ignored) {
                f = new File(url.getPath());
            }
            entry = new FileSystemHttpVfs.FileSystemEntry(f, path, contentEncoding);
        } else {
            entry = new ClassPathEntry(url, path, contentEncoding);
        }
        return entry;
    }

    @Override
    public String meterTag() {
        return "classpath:" + this.rootDir;
    }

    static final class ClassPathEntry
    extends HttpVfs.AbstractEntry {
        private final URL url;
        private final long lastModifiedMillis = System.currentTimeMillis();

        ClassPathEntry(URL url, String path, @Nullable String contentEncoding) {
            super(path, contentEncoding);
            this.url = url;
        }

        @Override
        public long lastModifiedMillis() {
            return this.lastModifiedMillis;
        }

        @Override
        public HttpData readContent() throws IOException {
            try (InputStream in = this.url.openStream();){
                HttpData httpData = this.readContent(in);
                return httpData;
            }
        }
    }
}

