/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.server.file.AbstractHttpVfs;
import com.linecorp.armeria.server.file.HttpVfs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nullable;

final class FileSystemHttpVfs
extends AbstractHttpVfs {
    private static final boolean FILE_SEPARATOR_IS_NOT_SLASH = File.separatorChar != '/';
    private final Path rootDir;

    FileSystemHttpVfs(Path rootDir) {
        this.rootDir = Objects.requireNonNull(rootDir, "rootDir").toAbsolutePath();
        if (!Files.exists(this.rootDir, new LinkOption[0]) || !Files.isDirectory(this.rootDir, new LinkOption[0])) {
            throw new IllegalArgumentException("rootDir: " + rootDir + " (not a directory");
        }
    }

    @Override
    public HttpVfs.Entry get(String path, @Nullable String contentEncoding) {
        File f;
        if (FILE_SEPARATOR_IS_NOT_SLASH) {
            path = path.replace(File.separatorChar, '/');
        }
        if (!(f = new File(this.rootDir + path)).isFile() || !f.canRead()) {
            return HttpVfs.Entry.NONE;
        }
        return new FileSystemEntry(f, path, contentEncoding);
    }

    @Override
    public String meterTag() {
        return "file:" + this.rootDir;
    }

    static final class FileSystemEntry
    extends HttpVfs.AbstractEntry {
        private final File file;

        FileSystemEntry(File file, String path, @Nullable String contentEncoding) {
            super(path, contentEncoding);
            this.file = file;
        }

        @Override
        public long lastModifiedMillis() {
            return this.file.lastModified();
        }

        @Override
        public HttpData readContent() throws IOException {
            long fileLength = this.file.length();
            if (fileLength > Integer.MAX_VALUE) {
                throw new IOException("file too large: " + this.file + " (" + fileLength + " bytes)");
            }
            try (FileInputStream in = new FileInputStream(this.file);){
                HttpData httpData = this.readContent(in, (int)fileLength);
                return httpData;
            }
        }
    }
}

