/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.metric.CaffeineMetricSupport;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.caffeine.cache.LoadingCache;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.file.HttpFileServiceBuilder;
import com.linecorp.armeria.server.file.HttpFileServiceConfig;
import com.linecorp.armeria.server.file.HttpVfs;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpFileService
extends AbstractHttpService {
    private static final Logger logger = LoggerFactory.getLogger(HttpFileService.class);
    private static final Splitter COMMA_SPLITTER = Splitter.on(',');
    private final HttpFileServiceConfig config;
    @Nullable
    private final LoadingCache<PathAndEncoding, CachedEntry> cache;

    public static HttpFileService forFileSystem(String rootDir) {
        return HttpFileServiceBuilder.forFileSystem(rootDir).build();
    }

    public static HttpFileService forFileSystem(Path rootDir) {
        return HttpFileServiceBuilder.forFileSystem(rootDir).build();
    }

    public static HttpFileService forClassPath(String rootDir) {
        return HttpFileServiceBuilder.forClassPath(rootDir).build();
    }

    public static HttpFileService forClassPath(ClassLoader classLoader, String rootDir) {
        return HttpFileServiceBuilder.forClassPath(classLoader, rootDir).build();
    }

    public static HttpFileService forVfs(HttpVfs vfs) {
        return HttpFileServiceBuilder.forVfs(vfs).build();
    }

    HttpFileService(HttpFileServiceConfig config) {
        this.config = Objects.requireNonNull(config, "config");
        this.cache = config.maxCacheEntries() != 0 ? Caffeine.newBuilder().maximumSize(config.maxCacheEntries()).recordStats().build(this::getEntryWithoutCache) : null;
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        MeterRegistry registry = cfg.server().meterRegistry();
        if (this.cache != null) {
            CaffeineMetricSupport.setup(registry, new MeterIdPrefix("armeria.server.file.vfsCache", "hostnamePattern", cfg.virtualHost().hostnamePattern(), "pathMapping", cfg.pathMapping().meterTag(), "vfs", this.config.vfs().meterTag()), this.cache);
        }
    }

    @Override
    public boolean shouldCachePath(String path, @Nullable String query, PathMapping pathMapping) {
        return this.cache != null;
    }

    public HttpFileServiceConfig config() {
        return this.config;
    }

    @Override
    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) {
        String contentEncoding;
        HttpData data;
        long ifModifiedSinceMillis;
        long lastModifiedMillis;
        HttpVfs.Entry entry;
        block9: {
            entry = this.getEntry(ctx, req);
            lastModifiedMillis = entry.lastModifiedMillis();
            if (lastModifiedMillis == 0L) {
                return HttpResponse.of(HttpStatus.NOT_FOUND);
            }
            ifModifiedSinceMillis = Long.MIN_VALUE;
            try {
                ifModifiedSinceMillis = req.headers().getTimeMillis(HttpHeaderNames.IF_MODIFIED_SINCE, Long.MIN_VALUE);
            }
            catch (Exception e) {
                if (e instanceof ParseException) break block9;
                throw e;
            }
        }
        ifModifiedSinceMillis = ifModifiedSinceMillis > 9223372036854774808L ? Long.MAX_VALUE : (ifModifiedSinceMillis += 999L);
        if (lastModifiedMillis < ifModifiedSinceMillis) {
            return HttpResponse.of((HttpHeaders)((HttpHeaders)HttpHeaders.of(HttpStatus.NOT_MODIFIED).setTimeMillis(HttpHeaderNames.DATE, this.config().clock().millis())).setTimeMillis(HttpHeaderNames.LAST_MODIFIED, lastModifiedMillis));
        }
        try {
            data = entry.readContent();
        }
        catch (FileNotFoundException ignored) {
            return HttpResponse.of(HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            logger.warn("{} Unexpected exception reading a file:", (Object)ctx, (Object)e);
            return HttpResponse.of(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        HttpHeaders headers = (HttpHeaders)((HttpHeaders)((HttpHeaders)HttpHeaders.of(HttpStatus.OK).setInt(HttpHeaderNames.CONTENT_LENGTH, data.length())).setTimeMillis(HttpHeaderNames.DATE, this.config().clock().millis())).setTimeMillis(HttpHeaderNames.LAST_MODIFIED, lastModifiedMillis);
        MediaType mediaType = entry.mediaType();
        if (mediaType != null) {
            headers.contentType(mediaType);
        }
        if ((contentEncoding = entry.contentEncoding()) != null) {
            headers.set(HttpHeaderNames.CONTENT_ENCODING, contentEncoding);
        }
        return HttpResponse.of(headers, data);
    }

    private HttpVfs.Entry getEntry(ServiceRequestContext ctx, HttpRequest req) {
        HttpVfs.Entry indexEntry;
        HttpVfs.Entry entry;
        String acceptEncoding;
        String decodedMappedPath = ctx.decodedMappedPath();
        EnumSet<FileServiceContentEncoding> supportedEncodings = EnumSet.noneOf(FileServiceContentEncoding.class);
        if (this.config.serveCompressedFiles() && (acceptEncoding = (String)req.headers().get(HttpHeaderNames.ACCEPT_ENCODING)) != null) {
            for (String encoding : COMMA_SPLITTER.split(acceptEncoding)) {
                for (FileServiceContentEncoding possibleEncoding : FileServiceContentEncoding.values()) {
                    if (!encoding.contains(possibleEncoding.headerValue)) continue;
                    supportedEncodings.add(possibleEncoding);
                }
            }
        }
        if ((entry = this.getEntryWithSupportedEncodings(decodedMappedPath, supportedEncodings)).lastModifiedMillis() == 0L && decodedMappedPath.charAt(decodedMappedPath.length() - 1) == '/' && (indexEntry = this.getEntryWithSupportedEncodings(decodedMappedPath + "index.html", supportedEncodings)).lastModifiedMillis() != 0L) {
            return indexEntry;
        }
        return entry;
    }

    private HttpVfs.Entry getEntry(String path, @Nullable String contentEncoding) {
        if (this.cache == null) {
            return this.config.vfs().get(path, contentEncoding);
        }
        PathAndEncoding pathAndEncoding = new PathAndEncoding(path, contentEncoding);
        CachedEntry entry = (CachedEntry)this.cache.getIfPresent(pathAndEncoding);
        if (entry == null) {
            return this.cache.get(pathAndEncoding);
        }
        if (this.config.vfs().get(path, contentEncoding).lastModifiedMillis() != entry.lastModifiedMillis()) {
            this.cache.invalidate(pathAndEncoding);
            return this.cache.get(pathAndEncoding);
        }
        return entry;
    }

    private CachedEntry getEntryWithoutCache(PathAndEncoding pathAndEncoding) {
        return new CachedEntry(this.config.vfs().get(pathAndEncoding.path, pathAndEncoding.contentEncoding), this.config.maxCacheEntrySizeBytes());
    }

    private HttpVfs.Entry getEntryWithSupportedEncodings(String path, EnumSet<FileServiceContentEncoding> supportedEncodings) {
        for (FileServiceContentEncoding encoding : supportedEncodings) {
            HttpVfs.Entry entry = this.getEntry(path + encoding.extension, encoding.headerValue);
            if (entry.lastModifiedMillis() == 0L) continue;
            return entry;
        }
        return this.getEntry(path, null);
    }

    public HttpService orElse(Service<HttpRequest, HttpResponse> nextService) {
        Objects.requireNonNull(nextService, "nextService");
        return new OrElseHttpService(this, nextService);
    }

    private static final class PathAndEncoding {
        private final String path;
        @Nullable
        private final String contentEncoding;

        PathAndEncoding(String path, @Nullable String contentEncoding) {
            this.path = path;
            this.contentEncoding = contentEncoding;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PathAndEncoding)) {
                return false;
            }
            return this.path.equals(((PathAndEncoding)obj).path) && Objects.equals(this.contentEncoding, ((PathAndEncoding)obj).contentEncoding);
        }

        public int hashCode() {
            return this.path.hashCode() * 31 + Objects.hashCode(this.contentEncoding);
        }
    }

    private static enum FileServiceContentEncoding {
        BROTLI(".br", "br"),
        GZIP(".gz", "gzip");

        private final String extension;
        private final String headerValue;

        private FileServiceContentEncoding(String extension, String headerValue) {
            this.extension = extension;
            this.headerValue = headerValue;
        }
    }

    private static final class OrElseHttpService
    extends AbstractHttpService {
        private final HttpFileService first;
        private final Service<HttpRequest, HttpResponse> second;

        OrElseHttpService(HttpFileService first, Service<HttpRequest, HttpResponse> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void serviceAdded(ServiceConfig cfg) throws Exception {
            this.first.serviceAdded(cfg);
            this.second.serviceAdded(cfg);
        }

        @Override
        public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
            HttpVfs.Entry firstEntry = this.first.getEntry(ctx, req);
            if (firstEntry.lastModifiedMillis() != 0L) {
                return this.first.serve(ctx, req);
            }
            return this.second.serve(ctx, req);
        }

        @Override
        public boolean shouldCachePath(String path, @Nullable String query, PathMapping pathMapping) {
            return this.first.shouldCachePath(path, query, pathMapping) && this.second.shouldCachePath(path, query, pathMapping);
        }
    }

    private static final class CachedEntry
    implements HttpVfs.Entry {
        private final HttpVfs.Entry entry;
        private final int maxCacheEntrySizeBytes;
        @Nullable
        private HttpData cachedContent;
        private volatile long cachedLastModifiedMillis;

        CachedEntry(HttpVfs.Entry entry, int maxCacheEntrySizeBytes) {
            this.entry = entry;
            this.maxCacheEntrySizeBytes = maxCacheEntrySizeBytes;
            this.cachedLastModifiedMillis = entry.lastModifiedMillis();
        }

        @Override
        public MediaType mediaType() {
            return this.entry.mediaType();
        }

        @Override
        @Nullable
        public String contentEncoding() {
            return this.entry.contentEncoding();
        }

        @Override
        public long lastModifiedMillis() {
            long newLastModifiedMillis = this.entry.lastModifiedMillis();
            if (newLastModifiedMillis != this.cachedLastModifiedMillis) {
                this.cachedLastModifiedMillis = newLastModifiedMillis;
                this.destroyContent();
            }
            return newLastModifiedMillis;
        }

        @Override
        public synchronized HttpData readContent() throws IOException {
            if (this.cachedContent == null) {
                HttpData newContent = this.entry.readContent();
                if (newContent.length() > this.maxCacheEntrySizeBytes) {
                    return newContent;
                }
                this.cachedContent = newContent;
            }
            return this.cachedContent;
        }

        synchronized void destroyContent() {
            if (this.cachedContent != null) {
                this.cachedContent = null;
            }
        }

        public String toString() {
            return this.entry.toString();
        }
    }
}

