/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.server.file.HttpFileService;
import com.linecorp.armeria.server.file.HttpFileServiceConfig;
import com.linecorp.armeria.server.file.HttpVfs;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Objects;

public final class HttpFileServiceBuilder {
    private final HttpVfs vfs;
    private Clock clock = Clock.systemUTC();
    private int maxCacheEntries = 1024;
    private int maxCacheEntrySizeBytes = 65536;
    private boolean serveCompressedFiles;

    public static HttpFileServiceBuilder forFileSystem(String rootDir) {
        return HttpFileServiceBuilder.forVfs(HttpVfs.ofFileSystem(rootDir));
    }

    public static HttpFileServiceBuilder forFileSystem(Path rootDir) {
        return HttpFileServiceBuilder.forVfs(HttpVfs.ofFileSystem(rootDir));
    }

    public static HttpFileServiceBuilder forClassPath(String rootDir) {
        return HttpFileServiceBuilder.forVfs(HttpVfs.ofClassPath(rootDir));
    }

    public static HttpFileServiceBuilder forClassPath(ClassLoader classLoader, String rootDir) {
        return HttpFileServiceBuilder.forVfs(HttpVfs.ofClassPath(classLoader, rootDir));
    }

    public static HttpFileServiceBuilder forVfs(HttpVfs vfs) {
        return new HttpFileServiceBuilder(vfs);
    }

    private HttpFileServiceBuilder(HttpVfs vfs) {
        this.vfs = Objects.requireNonNull(vfs, "vfs");
    }

    public HttpFileServiceBuilder clock(Clock clock) {
        this.clock = Objects.requireNonNull(clock, "clock");
        return this;
    }

    public HttpFileServiceBuilder maxCacheEntries(int maxCacheEntries) {
        this.maxCacheEntries = HttpFileServiceConfig.validateMaxCacheEntries(maxCacheEntries);
        return this;
    }

    public HttpFileServiceBuilder serveCompressedFiles(boolean serveCompressedFiles) {
        this.serveCompressedFiles = serveCompressedFiles;
        return this;
    }

    public HttpFileServiceBuilder maxCacheEntrySizeBytes(int maxCacheEntrySizeBytes) {
        this.maxCacheEntrySizeBytes = HttpFileServiceConfig.validateMaxCacheEntrySizeBytes(maxCacheEntrySizeBytes);
        return this;
    }

    public HttpFileService build() {
        return new HttpFileService(new HttpFileServiceConfig(this.vfs, this.clock, this.maxCacheEntries, this.maxCacheEntrySizeBytes, this.serveCompressedFiles));
    }

    public String toString() {
        return HttpFileServiceConfig.toString(this, this.vfs, this.clock, this.maxCacheEntries, this.maxCacheEntrySizeBytes);
    }
}

